/* scrysrv.h      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1990 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

#include <stdlib.h>
#ifndef EXCELAN
#include <rpc/rpc.h>
#include "\usr\local\src\nfsrpc\svc.h"
#include "\usr\local\src\nfsrpc\svc_auth.h"
#else
#include <rpc/rpc.h>
extern int break_enabled ;    /* signal enabled */
extern int abort_op ; /* abort operation */
#endif

#define PCPORT 2000	/* hard-wired PC port */

#define PROGNUM 300000L	/* program number */
#define TESTVERS 1L	/* version */

/* remote procedure numbers */

#define INITPROC 2L	/* initialize VTR or videodisk */
#define CLEARPROC 3L	/* clear PC display */
#define CLOSEPROC 4L	/* relinquish control */
#define FILENAMEPROC 5L	/* noop on PC, for compatibility only */
#define DISPLAYPROC 8L	/* display BTC and colormap-compressed image data */
#define VISPROC 11L

#define PREVIEW 0	/* just display; don't try to record */

#define MAXSOCKET 15	/* maximum number of Excelan sockets open */

extern int graphics_dispatch() ;	/* dispatch routine */

extern FILE *com1 ;	/* communication with videodisk occurs over com1 */
extern FILE *movie_log ;	/* movie log file */
extern int frame_done ;	/* avoids duplicate recording */
extern long record_on ;	/* recording is on */

struct recinfo		/* optical disk initialization information */
{
    long optflag ;	/* optical disk used or not */
    long start_frame ;	/* starting frame */
    long total ;	/* total frames requested to record on */
    char *username ;
    char *system_name ;
    char *movie_title ;
} ;

extern long s_optflag ;	/* optical disk or not */

/* XDR routines to decode incoming information */

extern bool_t xdr_map () ;	/* color map */
extern bool_t xdr_prelim() ;	/* incoming image information */
extern bool_t xdr_get_lzw() ;	/* gets LZW-compressed buffer */
extern bool_t xdr_visout() ;	/* server display information */
extern bool_t xdr_init_req() ;	/* information for recorder initialization */
extern bool_t xdr_init_ret() ;	/* information returned from recorder
				/* initialization */
extern bool_t xdr_ccc_decompress() ;	/* CCC decompress */
