/* atvista.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

#include <stdio.h>
#include <stage.h>
#include "image.h"


/* init_display:  initialize ATVista board
   clear_display:  clear frame buffer
   PutRow:  display one scan line      */


RGBColor	scry_black = {0, 0, 0} ;
Rect		curPortRect ;
GrafPortHdl     defaultPort ;
PixmapHdl       pixmap ;
Point		pt ;
Rect one_row ;

#define DEPTH 4		/* 32 bits (4 bytes) color resolution */

/* initializes ATVista board */

init_display ()

{
    int x, y ;

#ifndef NOGRAPHICS
    if (!StageAutoInit())
    {
        fprintf (stderr,"You have not installed the stage driver -- exiting\n") ;
        fprintf (stderr,"type   stage     to install\n") ;
        return (0) ;
    }
    else
    {
        defaultPort = GetDefaultPort() ;
        GetPortMap(&pixmap) ;
        SetPt(&pt,0,0) ;
        GetOrigin (&x, &y) ;
        curPortRect.x1 = x ;
        curPortRect.y1 = y ;
        GetPortSize (&x, &y) ;
        image_info.width = x ;
        image_info.height = y ;
	image_info.depth = DEPTH ;
        curPortRect.x2 = curPortRect.x1 + x ;
        curPortRect.y2 = curPortRect.y1 + y ;
	clear_display(0,0,0) ;
        return (1) ;
    }
#else
    image_info.width = 604 ;
    image_info.height = 486 ;
    image_info.depth = DEPTH ;
#endif
}




/* clears frame buffer */

clear_display(r,g,b)

int r, g, b ;

{
#ifndef NOGRAPHICS
    SetRGBBackColor(scry_black) ;
    EraseRect(curPortRect) ;
#endif
}




/* displays one scan line */

PutRow (buf,left,width,rownum,dummy)

unsigned char *buf ;
int left ;
int width ;
int rownum ;
int dummy ;

{
#ifndef NOGRAPHICS
    SetRect (&one_row,left,rownum,width+1,rownum+1) ;
    PutHostImage(pixmap,pt,one_row,buf,null,tmSrc,0L,0L,32) ;
#endif
}
