/* dispatch.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

#include <stdio.h>
#include <time.h>
#include "scrysrv.h"
#include "image.h"


/* noop structure: used if saving Anima file on X or Sunview
   server.  for compatibility only */

struct fileinfo
{
    long total_frames ;		/* total frames to save */
    char *filename[80] ;
} ;

struct fileinfo file_stuff ;




/* graphics dispatch:  contains remote procedures */


/* In RPC parlance, corresponds to remote program (graphics_dispatch was
   registered with svc_register).  Different cases are remote procedures. */

graphics_dispatch (rqstp,transp)

register struct svc_req *rqstp ;	/* RPC request data structure */
register SVCXPRT *transp ;		/* RPC transport handle */

{
        /* optical disk initialization info */
    struct recinfo record_return ;
    struct recinfo rec_sent ;
    long start_frame ;		/* starting frame number */
    FILE *movie_log ;
    long normal ;
    int i ;
    bool_t xdr_filesave() ;
    time_t current_time ;
    char time_string[80] ;

    switch ((int) rqstp->rq_proc)    /* which RPC */
    {
            /* NULL RPC call */
        case NULLPROC:
            printf ("NULLPROC called\n") ;
                /* send acknowledgement */
            if (svc_sendreply (transp,xdr_void,0) == 0)
            {
                fprintf (stderr,"err: rcp_service\n") ;
                return(0) ;
            }
            return (1) ;


            /* clear display */
        case CLEARPROC:
                /* send acknowledgement */
            if (svc_sendreply (transp,xdr_void,0) == 0)
            {
                fprintf (stderr,"err: rcp_service\n") ;
                return(0) ;
            }
            clear_display(0,0,0) ;
            return (1) ;


	   /* get starting videodisk frame */
       case INITPROC:
           if (!svc_getargs (transp,xdr_init_req,&rec_sent))
           {
               svcerr_decode(transp) ;
               return (0) ;
           }
	   if (record_on)
	   {
	       /* write to movie log file */
	       if ((movie_log = fopen("/movies/movie.log","a")) == NULL)
               {
                   fprintf (stderr,"couldn't open movie log file\n") ;
                   return(0) ;
               }

               start_frame = rec_sent.start_frame ;
                   /* get starting videotape frame number */
	           /* if recording requested by client */
               if (start_frame != PREVIEW)
                   init_frame (&start_frame,rec_sent.total) ;
               record_return.start_frame = start_frame ;
               record_return.optflag = s_optflag ;

               fprintf (movie_log,"user:  %s@%s\n",rec_sent.username,
                                                  rec_sent.system_name) ;
               time(&current_time) ;
               fprintf (movie_log,"date:  %s",ctime(&current_time)) ;
               fprintf (movie_log,"title:  %s\n",rec_sent.movie_title) ;
               fprintf (movie_log,"start frame: %ld\n",start_frame) ;
               fprintf (movie_log,"end frame:  %ld\n",start_frame + rec_sent.total - 1) ;
               fprintf (movie_log,"\n") ;
	       fclose(movie_log) ;
	   }
	   else
	   {
	       fprintf (stderr,"restart server:  use serv -r\n") ;
	       record_return.start_frame = 0 ;
	       record_return.optflag = 0 ;
	   }
           if (!svc_sendreply(transp,xdr_init_ret,&record_return))
           {
               fprintf (stderr,"can't reply\n") ;
               return (0) ;
           }
           return (1) ;

       case CLOSEPROC:
           printf ("\nCLOSEPROC called\n") ;
           if (!svc_getargs(transp,xdr_long,&normal))
           {
               svcerr_decode(transp) ;
               return(0) ;
           }
           if (record_on && (image_info.in_at != 0))
               stop_recording ();

               /* send acknowledgement */
           if (!svc_sendreply(transp,xdr_void,(char *) 0))
           {
               fprintf (stderr,"can't reply\n") ;
               return (0) ;
           }
           return (1) ;

	   /* optionally decompress, display, and optionally
	      record incoming image
	      acknowledgement to RPC sent within display_frame */
       case DISPLAYPROC:
           return (display_frame(transp)) ;

           /* return server display information to client */
       case VISPROC:
	      /* even if client requests, cannot record without
		 the use of the command-line -r option */
          image_info.recordable = record_on ;
           if (!svc_sendreply(transp,xdr_visout,&image_info))
           {
               fprintf (stderr,"can't reply to VISPROC\n") ;
               return (0) ;
           }
           return (1) ;

	   /* noop:  used on Xview and Sunview server to
	      get name to save Anima file under */

       case FILENAMEPROC:
            if (!svc_getargs(transp,xdr_filesave,&file_stuff))
            {
                svcerr_decode(transp) ;
                return(0) ;
            }
               /* send acknowledgement */
            if (!svc_sendreply(transp,xdr_void,(char *) 0))
            {
               	fprintf (stderr,"can't reply\n") ;
               	return (0) ;
            }
            return (1) ;



           /* couldn't find RPC - send error message */
       default:
           svcerr_noproc(transp) ;
           return(0) ;
    }
}




/* noop:  on X or Sunview server decodes name to save Anima
   file under */

bool_t 
xdr_filesave (xdrsp,file_stuff)

XDR *xdrsp ;		/* XDR handle */
struct fileinfo *file_stuff ;

{
        /* total frames to be saved */
    if (!xdr_long(xdrsp,&(file_stuff->total_frames)))
	return (0) ;
    if (!xdr_opaque(xdrsp,file_stuff->filename,80))
	return (0) ;
    return (1) ;
}
