/* scry_serv.h      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

/* information used by server */

#include <rpc/rpc.h>
#include <sys/socket.h>

extern int S_start ;	/* first frame or not */

extern int S_not_called ;	/* used to help Notifier and RPC server
			   	   to work together */

#define S_TESTVERS ((u_long) 1)	/* version */

/* remote procedure numbers */

#define S_INITPROC 2L	/* initialize video recorder */
#define S_CLEARPROC 3L	/* clear server display */
#define S_CLOSEPROC 4L	/* close session */
#define S_FILENAMEPROC 5L	/* gets name to save Anima file under */
#define S_DISPLAYPROC 8L	/* optionally decompress and display image */
#define S_VISPROC 11L	/* send X-style Visual info to client */

extern int break_handler() ;		/* branch to here on interrupt */
extern int graphics_dispatch() ;	/* dispatch routine */

extern bool_t xdr_visout() ;	/* XDR encode server display information */
extern bool_t xdr_map () ;	/* XDR decode color map */
extern bool_t xdr_image_info() ;	/* XDR decode information for display of image */
extern bool_t xdr_compressed() ;	/* XDR decode compressed image */
extern bool_t xdr_filesave() ;	/* XDR decode Anima file name */
extern bool_t xdr_init_req() ;	/* XDR decode incoming recording request */
extern bool_t xdr_init_ret() ;	/* XDR encode recording info for client */
