/* getfile.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


#include <stdio.h>
#include <scry_anima.h>

/* open an Anima file and read in footer */

getfile ()

{
    char iff_id[80] ;	/* should be "ncaa" */
    char anima_id[80] ;	/* should be "anima" */
    int frame ;		/* frame number */
    int i ;

    if(S_anima_file != NULL)
	fclose(S_anima_file);

    if((S_anima_file = fopen(S_anima_filename, "r")) == NULL)
    {
        perror("bad input file");
        return(0) ;
    }

    fscanf (S_anima_file,"%s\n",iff_id) ;
    if (strcmp(iff_id,"ncaa") != 0)
    {
        perror ("not an IFF file\n") ;
        return (0) ;
    }

        /* Check if the file contains an Anima footer */
    fseek(S_anima_file, -5L, 2);
    Fread(&anima_id[0], 5, 1, S_anima_file);
    anima_id[5] = 0;
    if(strcmp(anima_id, "anima") == 0)
    {
            /* Read the no. of frames in the file */
        fseek(S_anima_file, -35L, 2);
        fscanf(S_anima_file, "number of frames=%12ld\n",&S_anima_count) ;
            /* Read no. of bytes of data in the file */
            /* This is used to seek to the beginning of the Anima footer */
        fseek(S_anima_file, -65L, 2);
        fscanf(S_anima_file, "bytes to footer =%12ld\n",&S_anima_bytes) ;
        if(S_a_index != NULL)
        {
            if((S_a_index = Realloc(S_a_index, S_anima_count, struct footer)) == NULL)
            {
                perror("frame index array");
                return(0) ;
            }
        }
        else
        {
            if((S_a_index = Calloc(S_anima_count, struct footer)) == NULL)
            {
                perror("frame index array");
                return(0) ;
            }
        }
	    /* seek to the footer */
        fseek(S_anima_file, S_anima_bytes+3, 0) ;
            /* Read the footer image sequence information */
        for (i = S_anima_count-1 ; i >= 0 ; i--)
            fscanf(S_anima_file,"%ld %ld %ld\n",&frame,
                     &(S_a_index[i].buf_total),&(S_a_index[i].offset)) ;
        fseek(S_anima_file, 0L, 0);
    }
    else			/* Header array nonpresent */
    {
        fprintf (stderr,"Anima footer non-present\n") ;
        return(0) ;
    }
    return (1) ;
}
