/* xvdisplay.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


/* These procedures implement the routines necessary to handle image
   display under Xview.  These routines written by Antony
   A. Courtney, 5/11/89 and David Robertson 90 */

#include <stdio.h>
#include <math.h>
#include "xvwin.h"
#include <scry_serv.h>
#include <scry_image.h>
#include <scry_anima.h>
#include <scry_limits.h>
#include <xview/cms.h>

/* image_init:  creates server display window, canvas, and image memory
   init_vars:  initialize server display information
   Xserv_repaint:  repaint procedure
   make_rw_colormap:  make dynamic Xview colormap
   display_frame:  displays incoming image
   map_image_to_lut:  converts indices into Xview colormap indices */


int S_maxcol = S_MAX_COL_DISPLAY ;	/* maximum number of color table entries */
unsigned char S_map[S_MAX_COL_SIZE][3] ;	/* RGB color map */
int S_mapnum ;		/* number of entries in color map */
struct image_stuff S_image_info ;	/* control and/or image information */
int color_error_message = 1 ;	/* whether to print color error message */

Xv_opaque *ip ;
Xv_opaque image_win;
Xv_opaque image_canvas;
int image_screen ;
XID image_xid ;

unsigned long *colors ;

Display *display;
GC gc;
XGCValues gc_val ;
XVisualInfo *winv ;

XImage *image_win_image ;
unsigned char *S_image_mem = NULL ;

unsigned char red[S_MAX_COL_SIZE],green[S_MAX_COL_SIZE],blue[S_MAX_COL_SIZE] ;
Xv_cmsdata cms_data ;			/* Xview color handling */
float scry_gamma = S_DEF_GAMMA_VALUE ;	/* gamma value */



/* creates server display window, canvas, and image memory */

image_init(owner)

Xv_opaque owner ;

{
    int i ;
    int n ;
    void Xserv_repaint() ;	/* repaint procedure */

	/* initialize server display information */
    init_vars() ;

    image_win = xv_create(owner, FRAME,
		XV_LABEL, "Xserv image",
		XV_WIDTH, S_image_info.s_width,
		XV_HEIGHT, S_image_info.s_height,
		WIN_DYNAMIC_VISUAL, TRUE,
		OPENWIN_AUTO_CLEAR, TRUE,
	        0) ;

    image_canvas = xv_create(image_win, CANVAS,
		CANVAS_AUTO_EXPAND, TRUE,
		CANVAS_AUTO_SHRINK, TRUE,
		CANVAS_REPAINT_PROC, Xserv_repaint,
		0) ;

       /* make dynamic Xview color map */
    make_rw_colormap(&cms_data) ;
    (void) xv_set(image_canvas,
		WIN_CMS_NAME, "Xserv",
		WIN_CMS_DATA, &cms_data,
		CANVAS_RETAINED, FALSE,
		NULL) ;
    colors = (unsigned long *) xv_get(image_canvas, WIN_X_COLOR_INDICES);

    display = (Display *) xv_get(image_win, XV_DISPLAY, NULL) ;
    image_screen = DefaultScreen(display) ;
    gc = DefaultGC (display,image_screen) ;
    XSetForeground(display,gc,WhitePixel(display,image_screen)) ;

    image_xid = (XID) xv_get(canvas_paint_window(image_canvas), XV_XID);


    S_image_mem = (unsigned char *) malloc(S_image_info.s_height*S_image_info.s_width*sizeof(char));

    winv = (XVisualInfo *) malloc(sizeof(XVisualInfo));
    if ((int) XMatchVisualInfo(display, image_screen,
                               XDisplayPlanes(display, image_screen),
                               PseudoColor, winv) == 0)
    {
        fprintf(stderr, "unable to find correct visual \n");
        exit(0);
    }

    image_win_image = XCreateImage(display,winv->visual,8,ZPixmap,0,
		       S_image_mem,S_image_info.s_width,S_image_info.s_height,8,0) ;
    xv_set(image_win,XV_SHOW,TRUE,NULL) ;

}




/* initialize server display information */

init_vars()


{
    S_image_info.s_height = S_DEF_WINSERV_HEIGHT ;
    S_image_info.s_width = S_DEF_WINSERV_WIDTH ;
    S_image_info.s_max_height = S_MAX_WINSERV_HEIGHT ;
    S_image_info.s_max_width = S_MAX_WINSERV_WIDTH ;
    S_image_info.s_recordable = 0 ;
	/* only Pseudo Color supported */
	/* depth in bytes */
    S_image_info.s_depth = 1;

    S_image_info.data = (unsigned char *) calloc((S_image_info.s_height*S_image_info.s_width),sizeof(char)) ;
}




/* repaint procedure */

void
Xserv_repaint(canvas, paint_window, rects)

Canvas	canvas ;
Xv_window	paint_window;
Rectlist	*rects;

{
    if (!S_dont_repaint)
        XPutImage(display,image_xid,gc,image_win_image,0,0,0,0,
	      S_image_info.s_width,S_image_info.s_height) ;
}




/* make dynamic Xview color map */

make_rw_colormap(cms_data)

Xv_cmsdata *cms_data;

{
    int i ;

    cms_data->type = XV_DYNAMIC_CMS;
    cms_data->size = S_maxcol ;
    cms_data->rgb_count = S_maxcol ;
    cms_data->index = 0;
    cms_data->red = red;
    cms_data->green = green;
    cms_data->blue = blue;
}




/* optionally decompresses, and displays incoming image */

display_frame (transp)

register SVCXPRT *transp ;	/* RPC transport handle */

{
    unsigned char *part ;	/* position in compressed image */
    int save_total ;
    int i ;
    int numpixels = S_image_info.s_depth * S_image_info.s_height ;
    int repaint_status ;

    if (S_anima_file != NULL)
	    /* write info (frame no. and offset) to the header table array */
	    /* to be used by Anima */
        S_a_index[S_anima_count].offset = S_anima_bytes;

	/* get control information */
    if (!svc_getargs(transp,xdr_image_info,&S_image_info))
    {
        svcerr_decode(transp) ;
        return(0) ;
    }
    if ((S_image_info.s_width > S_MAX_WINSERV_WIDTH) ||
        (S_image_info.s_height > S_MAX_WINSERV_HEIGHT) ||
        (S_image_info.s_width < 1) || (S_image_info.s_height < 1))
	   {
	       fprintf (stderr,"illegal sized image\n") ;
	       exit(0) ;
	   }
	/* if image different size than previous
	      image received */
    if ((S_image_info.c_width != S_image_info.s_width) ||
	(S_image_info.c_height != S_image_info.s_height))
    {
	repaint_status = S_dont_repaint ;
	S_dont_repaint = 1 ;
	S_image_info.s_width = S_image_info.c_width ;
	S_image_info.s_height = S_image_info.c_height ;
	    /* redo image */
        (void) xv_set(image_win,
		XV_WIDTH, S_image_info.s_width,
		XV_HEIGHT, S_image_info.s_height,
		NULL) ;
	(void) xv_set(image_canvas,
		XV_X, 0,
		XV_Y, 0,
		XV_WIDTH, WIN_EXTEND_TO_EDGE,
		XV_HEIGHT, WIN_EXTEND_TO_EDGE,
		NULL) ;
	XDestroyImage(image_win_image) ;
	XFlush(display) ;
	free(S_image_mem) ;
	free(S_image_info.data) ;
	S_image_mem = (unsigned char *) malloc(S_image_info.s_height*S_image_info.s_width*sizeof(char)) ;
	S_image_info.data = (unsigned char *) calloc((S_image_info.s_height*S_image_info.s_width),sizeof(char)) ;
        image_win_image = XCreateImage(display,winv->visual,8,ZPixmap,0,
		       S_image_mem,S_image_info.s_width,S_image_info.s_height,8,0) ;
	XFlush(display) ;
	S_dont_repaint = repaint_status ;
    }
    if (S_anima_file != NULL)
    {
        S_a_index[S_anima_count].buf_total = S_image_info.total ;
        S_anima_count ++;
    }
        /* get color map */
    if (!svc_getargs(transp,xdr_map,S_map))
    {
        svcerr_decode(transp) ;
        return(0) ;
    }

        /* write out IFF header if client enabled writing to Anima file */
	/* CCC is only legal compression option */
    if ((S_anima_file != NULL) && !(S_image_info.compression & S_QUANTIZE))
            iff_write_header (S_anima_file,&S_image_info,S_image_info.s_height,
			      S_image_info.s_width,"many map Anima file") ;
               
	/* if Lempel-Ziv compression was used */
    if (S_image_info.compression & S_LEMPEL_ZIV)
    {
        save_total = S_image_info.total ;
	S_image_info.total = S_image_info.total_lz ;
	    /* get compressed info */
        if (!svc_getargs(transp,xdr_compressed,&S_image_info))
        {
	    svcerr_decode(transp) ;
	    return (0) ;
        }
	/* send acknowledgement - allows client to continue while
           decompression and display taking place. */
        if (svc_sendreply (transp,xdr_void,0) == 0)
        {
             fprintf (stderr,"err: rcp_service\n") ;
             return(0) ;
        }
	    /* decompress */
        lzw_decomp (S_image_info.data, &S_image_info.total) ;
        S_image_info.total = save_total ;
    }
    else
    {
            /* if Lempel-Ziv compression was not used on client */
        if (!svc_getargs(transp,xdr_compressed,&S_image_info))
        {
            svcerr_decode(transp) ;
            return(0) ;
        }
	    /* send acknowledgement - allow client to continue */
        if (svc_sendreply (transp,xdr_void,0) == 0)
        {
            fprintf (stderr,"err: rcp_service\n") ;
            return(0) ;
        }
    }
        /* if writing enabled, write out compressed image */
    if ((S_anima_file != NULL) && !(S_image_info.compression & S_QUANTIZE))
    {
        iff_write_buf(S_anima_file,&S_image_info) ;
    }
	/* if writing enabled and all frames have been received, write
	   Anima footer */
    if ((S_anima_file != NULL) && (S_image_info.total_frames == (S_image_info.current_frame_to_save + 1)))
    {
#ifdef MESSAGES
        fprintf (stderr,"writing Anima footer\n") ;
#endif
        anima_write_footer (S_anima_file) ;
        fclose(S_anima_file) ;
        anima_init() ;
    }
    if (S_mapnum > S_maxcol)
    {
	if (color_error_message)
	{
            fprintf (stderr,"Incorrect color display results from a bad setting\n") ;
	    fprintf (stderr,"of the maximum # of colors; in the future, try\n") ;
	    fprintf (stderr,"setting more colors with the -c option.\n") ;
	    fprintf (stderr,"If saving an Anima file, the incorrect display\n") ;
	    fprintf (stderr,"does not mean incorrect colors within the file.\n") ;
	    color_error_message = 0 ;
	}
        S_mapnum = S_maxcol ;
    }
        /* load the colormap */
    for (i=0; i<S_mapnum;i++)
    {
        red[i] = S_map[i][S_RED];
        green[i] = S_map[i][S_GREEN];
        blue[i] = S_map[i][S_BLUE];
    }
    for (i = 0; i < S_mapnum; i++)
    {
	    /* do gamma correction */
	if (scry_gamma != 1.0)
	{
	    red[i] = (int) (256. * pow((double) red[i] / 256., 1.0 / scry_gamma));
	    if (red[i] > 255)
	        red[i] = 255;
	    green[i] = (int) (256. * pow((double) green[i] / 256., 1.0 / scry_gamma));
	    if (green[i] > 255)
	        green[i] = 255;
	    blue[i] = (int) (256. * pow((double) blue[i] / 256., 1.0 / scry_gamma));
	    if (blue[i] > 255)
	        blue[i] = 255;
	}
    }

    cms_data.rgb_count = S_mapnum;

        /* CCC decompression */
    if (S_image_info.compression & S_CCC)
        decompress_ccc (S_image_info.data,S_image_mem,S_image_info.s_height,S_image_info.s_width,colors);
    else
    {		/* get 8-bit image */
        for (i = 0 ; i < S_image_info.s_height ; i++)
                bcopy (&(S_image_info.data[i*S_image_info.s_width]),
                   &(S_image_mem[i * S_image_info.s_width]), S_image_info.s_width) ;
    }
	/* reset color map */
    make_rw_colormap(&cms_data) ;
    xv_set(image_canvas,
		WIN_CMS_NAME, "Xserv",
		WIN_CMS_DATA, &cms_data,
		NULL) ;

        /* if 8-bit image, remap indices */
    if (S_image_info.compression & S_QUANTIZE)
        map_image_to_lut(S_image_mem,S_image_info.s_width*S_image_info.s_height) ;
    XFlush(display) ;
    XPutImage(display,image_xid,gc,image_win_image,0,0,0,0,
	      S_image_info.s_width,S_image_info.s_height) ;
    XFlush(display) ;
    S_dont_repaint = 0 ;

    return (1) ;
}




/* converts indices into X color map indices */

map_image_to_lut(buf,bufsize)

unsigned char *buf ;
int bufsize ;

{
    int i ;

    for (i = 0 ; i < bufsize ; i++)
	S_image_mem[i] = (unsigned char) colors[S_image_mem[i]] ;
}
