/* convert.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */


#include <stdio.h>
#include <scry_anima.h>
#include <scry_image.h>
#include <scry_limits.h>

unsigned char final_map[S_MAX_COL_SIZE][3] ;	/* color map for entire file */
long final_mapnum ;	/* number of entries in final color map */
extern long max_color ;	/* maximum number of quantization entries */

char anima_format[80] ;


/* analyze_frame:  analyzes one frame of an Anima file during the
   2-pass process of generating one color map for the entire file.    */

analyze_frame(current,pass_num,out)

int current ;	/* current frame number */
int pass_num ;	/* 1st or 2nd pass */
FILE *out ;

{
    register int i;
    unsigned int histo_map[S_MAX_COL_SIZE] ;	/* histogram */
    int height, width ;
    

    fseek(S_anima_file, S_a_index[current].offset, 0);
    if (pass_num == 2)
	   /* update Anima footer */
       S_a_index[current].offset = S_anima_bytes ;
	   /* read IFF header */
    if(!iff_read_header(S_anima_file, &S_image_info, &height, &width,anima_format))
    {
	fprintf("iff_read_header failed\n");
	exit(0) ;
    }
    
	/* total bytes in compressed image */
    S_image_info.total = S_a_index[current].buf_total ;
        /* get the image */
    iff_read_buf(S_anima_file, &S_image_info);
    
    if (pass_num == 1)	/* find frequency of colors in color map */
    {
	for (i = 0 ; i < S_MAX_COL_SIZE ; i++)
	    histo_map[i] = 0 ;
	if (!(S_image_info.compression & S_QUANTIZE))
                /* add to color map histogram for this frame */
            ccc_histo(S_image_info.data,histo_map);
	else
	{
	    fprintf (stderr,"doesn't work on 8 bit images in this revision\n") ;
            exit(0) ;
	}
    }

        /* if first pass, does preparation (data structures for
	       frequencies, etc.
	   if second pass, perform quantization */
    final_mapnum = quantize(histo_map,S_image_info.data,max_color,S_image_info.s_height,S_image_info.s_width,pass_num) ;
    if (pass_num == 2)
    {
	   /* only do once */
        if (current == 0)
        {
		/* for TAAC compatiblity:  first entry must be black */
            for (i = (final_mapnum - 1) ; i >= 0 ; i--)
            {
                S_map[i+1][S_RED] = final_map[i][S_RED] ;
                S_map[i+1][S_GREEN] = final_map[i][S_GREEN] ;
                S_map[i+1][S_BLUE] = final_map[i][S_BLUE] ;
            }
	    S_map[0][S_RED] = 0 ;
	    S_map[0][S_GREEN] = 0 ;
	    S_map[0][S_BLUE] = 0 ;
            S_mapnum = final_mapnum + 1 ;
	    S_anima_bytes = 0 ;
	    strcpy(anima_format,"one map Anima file") ;
		/* write IFF header */
            iff_write_header(out,&S_image_info,S_image_info.s_height,S_image_info.s_width,anima_format) ;
	}
	    /* write compressed image */
        iff_write_buf(out,&S_image_info) ;
    }
}
