/* ccconv.c      Distribution 1.2   91/1/28   Scry */

/*   The Scry system is copyright (C) 1988-1991 Regents  of  the
University  of  California.   Anyone may reproduce ``Scry'',
the software in this distribution, in whole or in part, pro-
vided that:

(1)  Any copy  or  redistribution  of  Scry  must  show  the
     Regents  of  the  University of California, through its
     Lawrence Berkeley Laboratory, as the source,  and  must
     include this notice;

(2)  Any use of this software must reference this  distribu-
     tion,  state that the software copyright is held by the
     Regents of the University of California, and  that  the
     software is used by their permission.

     It is acknowledged that the U.S. Government has  rights
in  Scry  under  Contract DE-AC03-765F00098 between the U.S.
Department of Energy and the University of California.

     Scry is provided as a professional  academic  contribu-
tion  for  joint exchange.  Thus it is experimental, is pro-
vided ``as is'', with no warranties of any kind  whatsoever,
no  support,  promise  of updates, or printed documentation.
The Regents of the University of California  shall  have  no
liability  with respect to the infringement of copyrights by
Scry, or any part thereof. */

#include	<stdio.h> 
#include	<scry_anima.h>
#include	<scry_image.h>


/* init_newrun_length:  initialize run length variables
   convert_ccc:  convert from old format compression to IFF format */


#define SIZBLOC 4	/* BTC block is 4x4 */

static int ccc_prev_color ;		/* run length color */
static unsigned short ccc_run_ctr ;
static int ccc_finished ;		/* run finished */


/* initialize run length variables */

init_newrun_length()

{
    ccc_prev_color = -1 ;
    ccc_run_ctr = 1 ;
    ccc_finished = 1 ;
}




/* convert from old format compression to IFF format for group of 4 scan lines */

unsigned char *convert_ccc(ptin, outstart, to_send, last) 

unsigned char *ptin ;		/* old group of scan lines */
unsigned char **outstart;	/* beginning of new group */
short *to_send;			/* total bytes in converted scan lines */
int last ;			/* whether last group of scan lines or not */

{     
    int block_width_num ;	/* number of blocks in row */
    register short unsigned old_bitmap;	/* old BTC bitmap */
    unsigned short new_bitmap ;		/* new BTC bitmap */
    unsigned char tempind;		/* used in checking for run */
    int switch_color ;			/* used in switching first and second colors */
    unsigned char *ptout ;		/* pointer to output */
    unsigned short make_one_run ;	/* if needed to make a run of length one */
    int	i;
    
    block_width_num = S_image_info.s_width / SIZBLOC ;
    *to_send = 0;
    ptout = *outstart ;
    for(i = 0; i < block_width_num; i++)
    {
        old_bitmap = *ptin++ ;
        old_bitmap = old_bitmap | (*ptin << 8 ) ;
	ptin++ ;
	if(old_bitmap)	/* if two colors */
	{
		/* if at end of a run */
	    if ((!ccc_finished) && (ccc_prev_color >= 0))
	    {
		*ptout++ = (unsigned char) (ccc_prev_color+1) ;
	        *ptout++ = (unsigned char) (ccc_prev_color+1) ;
	        *ptout++ = (ccc_run_ctr >> 8) & 0xff;
	        *ptout++ = ccc_run_ctr & 0xff;
	        *to_send += SIZBLOC;
	    }
	    ccc_prev_color = -1 ;
	    ccc_finished = 1 ;
	    ccc_run_ctr = 1 ;
	    make_one_run = 0 ;
		/* if for some reason 2 colors are identical, make a run of
		   length 1 */
	    if (*ptin == *(ptin+1))
		make_one_run = 1 ;
	    switch_color = (int)*ptin + 1;	/* switch first and second color */
	    *ptin++ ;
	    *ptout++ = (unsigned char) ((int)*ptin + 1);
	    *ptin++ ;
	    *ptout++ = (unsigned char) switch_color;
		/* rearrange bit map */
	    new_bitmap = (old_bitmap & 0xf000) >> 12 ;
	    new_bitmap |= (old_bitmap & 0x0f00) >> 4 ;
	    new_bitmap |= (old_bitmap & 0x00f0) << 4 ;
	    new_bitmap |= (old_bitmap & 0x000f) << 12 ;
	    if (!make_one_run)
	    {
	        *ptout++ = (new_bitmap >> 8) & 0xff;
	        *ptout++ = new_bitmap & 0xff;
	    }
	    else
	    {
		*ptout++ = 0 ;
		*ptout++ = 1 ;
	    }
	    *to_send += SIZBLOC;
	}
	else
	{
	        /* try run-length encoding */
	    tempind = *ptin++;
	    ccc_finished = 0 ;
		/* if run is continuing */
	    if ((int)tempind == ccc_prev_color)
	    {
		++ccc_run_ctr ;
		if (ccc_run_ctr > 128)
		    printf ("bad run ctr: %d\n",ccc_run_ctr) ;
	    }
	    else if (ccc_prev_color >= 0)	/* finish run */
	    {
		*ptout++ = (unsigned char) (ccc_prev_color+1) ;
	        *ptout++ = (unsigned char) (ccc_prev_color+1) ;
	        *ptout++ = (ccc_run_ctr >> 8) & 0xff;
	        *ptout++ = ccc_run_ctr & 0xff;
		if (ccc_run_ctr > 128)
		    printf ("bad run ctr: %d\n",ccc_run_ctr) ;
	        *to_send += SIZBLOC;
		ccc_run_ctr = 1 ;
		ccc_prev_color = (int)tempind ;
	    }
	    else	/* at start of a run */
                ccc_prev_color = (int)tempind ;
	}
    }
	/* finish up if necessary at end of row */
    if (!ccc_finished)
    {
        *ptout++ = (unsigned char) (ccc_prev_color+1) ;
        *ptout++ = (unsigned char) (ccc_prev_color+1) ;
        *ptout++ = (ccc_run_ctr >> 8) & 0xff;
        *ptout++ = ccc_run_ctr & 0xff;
        if (ccc_run_ctr > 128)
            printf ("bad run ctr: %d\n",ccc_run_ctr) ;
        *to_send += SIZBLOC;
    }
    *outstart = ptout ;
    return(ptin);
}
