/*	PROGRAM
 *		hiplprnt
 *
 *	PURPOSE
 *		to generate a hard copy of an image on        
 *              the printer using hips format
 *
 *	SYNOPSIS
 *		hiplprnt <inseq
 *	-   image files are assumed to be in the current directory
 *	-   argument definitions:
 *	    +  <inseq :    name of image file to be printed
 *				 
 *	AUTHOR
 *		Ann Adams            
 *	        for
 *		Merickel Imaging Lab
 *		Biomedical Engineering
 *		University of Virginia
 *		Charlottesville, Va.  22903
 */
#include <termio.h>
#include <stdio.h>
#include <hipl_format.h>
#include <math.h>
#define READ 0
#define FBWIDTH 512
char *Progname;

main(ac,av)
int ac;
char *av[];
{
	FILE *prntr;	/* pointer to printer */
	struct termio bufio;   /* storage area for I/O control */
	struct header hd;   /* storage area for header information */
	int i, n, m, j, k, l, rnd, infd, cols, rows, ttyfd;
	int nextno, sect, numb;
        int bufint[7][128],prnbuf[28][512];  /* image and printer info */
	char EL, SO, ETX, STX, CHR, FF;   /* printer control codes */
	char buf[BUFSIZ], outbf0[5],outbf1[5], outbf2[5], outbf3[5], outbf4[5];
	unsigned char *ifr, *pifr;  /* pointers to image section in memory */
	char outbfff[5];

	Progname = strsave(*av);
	/* open image file*/
	read_header(&hd);
	if (hd.pixel_format != PFBYTE)
		perr("image must be in byte format");
	cols = hd.cols;   
	rows = hd.rows;   

/* allocate memory for 7 rows of image */
	pifr = (unsigned char *) halloc(7*cols,sizeof(unsigned char));

	/* open data stream to printer   */
	if((ttyfd= open("/dev/lp",1)) < 0)
		perr("prntchk: prntr tty line is blocked");
	/* open printer file for writing */
	prntr=fdopen(ttyfd,"w");
	setbuf(prntr,buf);

	/* set character parameters   */
	EL=28;		/* elite text */
	SO=14;		/* normal text */
	ETX=3;		/* mode change to graphics */
	STX=2;		/* mode change to normal */
        FF=12;		/* form feed */
        sprintf(outbf1,"%c",EL);
	sprintf(outbf0,"%c",ETX);
	sprintf(outbf3,"%c",SO);
	sprintf(outbf2,"%c",STX);
	sprintf(outbfff,"%c",FF);

	/* set I/O control parameters  */  	
        ioctl(ttyfd,TCGETA,&bufio);   /* get present control values */
	bufio.c_oflag &= ~OPOST;      /* no post processing allowed */
	bufio.c_iflag |= IXON;        /* allow for output */
	bufio.c_iflag |= BRKINT;
	bufio.c_iflag |= ISTRIP;
	bufio.c_iflag |= IXOFF;
	bufio.c_cflag |= PARENB;
	bufio.c_cflag |= CSTOPB;
	bufio.c_cflag |= CLOCAL;
	bufio.c_cflag &= ~HUPCL;
 	ioctl(ttyfd,TCSETA,&bufio);    /* set new control values */

	/* put printer into graphics and elite mode   */
	write(ttyfd,outbf1,strlen(outbf1));
	write(ttyfd,outbf0,strlen(outbf0));
       
        /* read in the next image section */
	for (sect=0;sect<(rows/7);sect++)
	{     ifr = pifr;		  /* read in 7 image lines */
	if (pread(0,ifr,7*cols*sizeof(unsigned char)) != 
		7*cols*sizeof(unsigned char))
	{  printf("cannot read file into memory\n");
	write(ttyfd,outbf0,strlen(outbf0));   /* exit if file not  */
	write(ttyfd,outbf3,strlen(outbf3));   /* read as expected  */
	write(ttyfd,outbf0,strlen(outbf0));   /* reset the printer */
	write(ttyfd,outbf2,strlen(outbf2));   /* to normal mode    */
        bufio.c_oflag |= OPOST;		      /* and reset the I/O */
 	ioctl(ttyfd,TCSETA,&bufio);           /* control values to */
	perr("cannot read file into memory"); /* old values        */
	}
         for (i=0; i<7; i++)
         {  
                for (j=0 ; j<cols ; j++)    /* convert image to int form */
                {  	bufint[i][j]= (int)(*ifr);
			ifr++;
		}
          }
          for (i=0;i<7;i++)		    /* convert next 7 for output */
          {   for (j=0;j<cols;j++)
	      {   nextno = (int)((float)(bufint[i][j])/14.23);
		  if (nextno < 9)	    /* dark regions filled with 1's */
		  {  for (k=0;k<4;k++)
		     {   for (l=0;l<4;l++)
			 {   m = i * 4 + k;
			     n = j * 4 + l;
			     prnbuf[m][n] = 1;
		  	 }
		     }
		     if (nextno == 8)	/* take care of repetition problem */
			nextno = 10;
		     if (nextno == 7)
			nextno = 8;

		     for (k=0;k<nextno;k++)   /* fit 4x4 to gray level   */
		     {   rnd = rand()/2048;   /* by random dot placement */
			 m = i*4;
			 n = j*4;
			 if (rnd ==1) m = m+1;
			 if (rnd ==2) m = m+2;
			 if (rnd ==3) m = m+3;
			 if (rnd ==4) n = n+1;
			 if (rnd ==5)
			 {  m = m+1;
			    n = n+1;
			 }
			 if (rnd ==6)
			 {  m = m+2;
			    n = n+1;
			 }
			 if (rnd ==7)
			 {  m = m+3;
			    n = n+1;
			 }
			 if (rnd ==8) n = n+2;
			 if (rnd ==9) 
			 {  m = m+1;
			    n = n+2;
			 }
			 if (rnd ==10)
			 {  m = m+2;
			    n = n+2;
			 }
			 if (rnd ==11)
			 {  m = m+3;
  			    n = n+2;
			 }
			 if (rnd ==12) n = n+3;
			 if (rnd ==13)
			 {  m = m+1;
			    n = n+3;
			 }
			 if (rnd ==14)
			 {  m = m+2;
			    n = n+3;
			 }
			 if (rnd ==15)
			 {  m = m+3;
			    n = n+3;
			 } 
		  	 prnbuf[m][n] = 0;     /* fill in randomly placed 0 */
		     } 
		  nextno -= 2;     /* reverse process for repeated numbers */
	          } 
                  if (nextno >= 9)   /* light area */
		  {  for (k=0;k<4;k++)
		     {   for (l=0;l<4;l++)
			 {   m = i * 4 + k;
			     n = j * 4 + l;
			     prnbuf[m][n] = 0;
		  	 }
		     }
		     if (nextno == 9)  /* repeated number problem */
			nextno = 7;
		     if (nextno == 10)
			nextno = 9;

		     for (k=0;k<(16-nextno);k++)
		     {   rnd = rand()/2048;
			 m = i*4;
			 n = j*4;
			 if (rnd ==1) m = m+1;
			 if (rnd ==2) m = m+2;
			 if (rnd ==3) m = m+3;
			 if (rnd ==4) n = n+1;
			 if (rnd ==5)
			 {  m = m+1;
			    n = n+1;
			 }
			 if (rnd ==6)
			 {  m = m+2;
			    n = n+1;
			 }
			 if (rnd ==7)
			 {  m = m+3;
			    n = n+1;
			 }
			 if (rnd ==8) n = n+2;
			 if (rnd ==9) 
			 {  m = m+1;
			    n = n+2;
			 }
			 if (rnd ==10)
			 {  m = m+2;
			    n = n+2;
			 }
			 if (rnd ==11)
			 {  m = m+3;
  			    n = n+2;
			 }
			 if (rnd ==12) n = n+3;
			 if (rnd ==13)
			 {  m = m+1;
			    n = n+3;
			 }
			 if (rnd ==14)
			 {  m = m+2;
			    n = n+3;
			 }
			 if (rnd ==15)
			 {  m = m+3;
			    n = n+3;
			 } 
			 prnbuf[m][n] = 1;  /* fill in randomly placed 1 */    
   	            }
		}
   	     }	
          }

	  for (i=0;i<4;i++)    /* calculate graphical # output */
	  {   for (j=0;j<(cols*4);j++)
	      {   numb = 0;
	          for (k=6;k>=0;k--)
		  {   m = i*7 + k;
		      numb = (numb * 2) + prnbuf[m][j];
		  }
       		  if (numb == 0)  /* 0's do not print, set high order bit */
		     numb = 128; 
	          CHR=(char)(numb);  /* convert to character form */
		  sprintf(outbf4,"%c",CHR);
		  write(ttyfd,outbf4,strlen(outbf4));  /* print output */
		  if (numb ==3)    /* 3's must be repeated (control) */
		     write(ttyfd,outbf4,strlen(outbf4)); 
              } 
	  write(ttyfd,outbf0,strlen(outbf0)); /* graphical line feed and */
	  write(ttyfd,outbf3,strlen(outbf3)); /* carriage return         */
	  }
	}
	write(ttyfd,outbf0,strlen(outbf0));  /* return to normal printing */
	write(ttyfd,outbf3,strlen(outbf3));  /* mode                      */
	write(ttyfd,outbf0,strlen(outbf0));
	write(ttyfd,outbf2,strlen(outbf2));
        bufio.c_oflag |= OPOST;		     /* reset I/O control */
        ioctl(ttyfd,TCSETA,&bufio);
	write(ttyfd,outbfff,strlen(outbfff));   /* form feed for next use */
	close(ttyfd);
}
