
/*
 *  view.c            -Brian Tierney,  LBL
 *  for use with segal
 *  these routines are for displaying the image
 */

#include "segal.h"


/* these need to be global */
view_win_objects *view_win;

/************************************************************/
void
view_win_init(owner)
    Xv_opaque owner;
{
    void      make_cms_colormap();

    view_win = view_win_objects_initialize(NULL, owner);

    make_cms_colormap();
    (void) xv_set(view_win->canvas, WIN_CMS_NAME, "segal", NULL);
    (void) xv_set(view_win->canvas, WIN_CMS_DATA, &cms_data, NULL);


    /* set pointers to colormap */
    colors = (u_long *) xv_get(view_win->canvas, WIN_X_COLOR_INDICES);
    standout = colors[NGRAY * 2];
}

/*************************************************************
 * Repaint callback function for `canvas'.
 */
void
image_repaint_proc()
{
    if (xv_get(view_win->win, XV_SHOW, NULL) == FALSE)
	return;

    XPutImage(display, view_xid, gc, image, 0, 0, 0, 0,
		  image->width, image->height);
}

/**************************************************************/
void
map_image_to_lut(buf, newbuf, bufsize)  
 /* used to map the image to the color look-up-table based
    on the value of NGRAY */

    u_char   *buf;		/* image */
    u_char   *newbuf;
    int       bufsize;
{
    int       i;
    u_char    j;
    float     scale = NGRAY./ 257.;

    for (i = 0; i < bufsize; i++) {
	/* scale to 0 to NGRAY */
	j = (u_char) (buf[i] * scale);
	if (j >= NGRAY)
	    j = NGRAY - 1;
	/* map to lookup table */
	newbuf[i] = (u_char) colors[j];
    }
}

/**************************************************************************/
void
make_cms_colormap()
{
    int       i, j;
    int       color_size = NGRAY + 1;	/* 1 standout color */
    u_char    red[NGRAY + 1], green[NGRAY  + 1], blue[NGRAY + 1];
    double    gammaval;
    int       r, g, b;

    gammaval = (float) xv_get(segal_win->gamma_val, PANEL_VALUE, NULL) / 10.;
    if (verbose)
	fprintf(stderr, "setting colormap: gamma value of %.1f \n", gammaval);

    for (i = 0; i < NGRAY; i++) {
	if (gammaval == 1.0)
	    j = (int) ((i * 257.) / NGRAY.);
	else
	    j = (int) (257. * pow((double) i / NGRAY., 1.0 / gammaval));
	if (j > 255)
	    j = 255;
	red[i] = blue[i] = green[i] = (u_char) j;
    }

    /* standout color = green */
    green[NGRAY * 2] = 255;
    red[NGRAY * 2] = blue[NGRAY * 2] = 0;

    cms_data.type = XV_DYNAMIC_CMS;
    cms_data.size = color_size;
    cms_data.rgb_count = color_size;
    cms_data.index = 0;
    cms_data.red = red;
    cms_data.green = green;
    cms_data.blue = blue;

#ifdef SHOW_COLORS
    fprintf(stderr, "after setting colors... \n");
    for (i = 0; i < NGRAY * 2; i++)
	fprintf(stderr, "color table: red = %d, green = %d, blue = %d \n",
		cms_data.red[i], cms_data.green[i], cms_data.blue[i]);
#endif
}

/**************************************************/
void
change_colormap(item, event)  /* procedure called when adjusting contrast */
    Panel_item item;
    Event    *event;
{
    void      make_cms_colormap();

    if ((int) xv_get(view_win->win, XV_SHOW, NULL) == FALSE)
	return;

    make_cms_colormap();

    (void) xv_set(view_win->canvas, WIN_CMS_DATA, &cms_data, NULL);
    (void) xv_set(edit_win->canvas, WIN_CMS_DATA, &cms_data, NULL);
}

