/*	Copyright (c) 1982 Michael Landy, Yoav Cohen, and George Sperling

Disclaimer:  No guarantees of performance accompany this software,
nor is any responsibility assumed on the part of the authors.  All the
software has been tested extensively and every effort has been made to
insure its reliability.   */

/*
 * ftocc - converts floating images to complex (i and r equal to float image)
 *
 * usage:	ftocc <iseq >oseq
 *
 * to load:	cc -o ftocc ftocc.c -lhipl
 *
 * Mike Landy - 5/26/82
 */

#include <stdio.h>
#include <hipl_format.h>
char *Progname;

main(argc,argv)

char *argv[];

{
	int factor,fr,r,c,b,i,j,k;
	struct header hd;

	Progname = strsave(*argv);
	read_header (&hd);
	if(hd.pixel_format != PFFLOAT)
		perr("pixel format must be floating");
	r = hd.rows; c = hd.cols;
	fr = hd.num_frame;
	hd.pixel_format = PFCOMPLEX;
	hd.bits_per_pixel = 64;
	update_header (&hd,argc,argv);
	write_header (&hd);
	i = ftoc(fr,r,c);
	return(0);
}

ftoc(fr,r,c)

int fr, r, c;

{
	int	f,i,j;
	float *ofr,*op;
	float *ifr,*ip;

	ifr = (float *) halloc(r*c,sizeof (float));
	ofr = (float *) halloc(2*r*c,sizeof (float));
	for (f=0;f<fr;f++) {
		if (pread(0,ifr,r*c*sizeof(float)) != r*c*sizeof(float))
			perr("error during read");
		ip = ifr;
		op = ofr;
		for (i=0;i<r;i++) {
			for (j=0;j<c;j++) {
				*op++ = *ip;
				*op++ =  *ip++;
			}
		}
		if (write(1,ofr,2*r*c*sizeof(float)) != 2*r*c*sizeof(float))
			perr("error during write");
	}
}
