.TH HIPS 1 "1 May 1990" "LBL"
.SH NAME
.B segal tutorial: 
A short tutorial in the use of 
.I segal
(SEGmentation AnaLyzer), a binary mask editor/builder/analyzer for HIPS images.
.SH SYNOPSIS
.B segal
[-i image][-m mask] [-v] [-c NN]
.SH DESCRIPTION
.I segal
is an X-windows  tool for interactively editing, creating, and analyzing
binary mask images. In
.I segal
a mask is transparently laid over the original image, then using the
mouse, one can "cut" or "fill" in the mask, exposing the image beneath.
A new mask can be created by selecting the image threshold value.
The user can select between various size paint/erase cursors, and 
select various zoom magnifications, to aid in building the mask.
The image must be of type byte, and it is best if the image is contrast
enhanced using a program such as
.I mahe
or
.I
hstr.
A mask can also be edited/created without an image overlay.
.I segal
also does statistical measurements on objects in the binary mask image.
.\"=============================================================
.SH TUTORIAL #1
.TP 50
.B Creating and editing a new mask
.TP 3
.na
.nf
1) start up segal:
    segal -i image <cr>  
	-where 'image' is the name of a byte-formatted 
	HIPS image file. This will load and display the image.
.TP 3
2) move the 'threshold' slider to a value of about 100, 
      and click on 'mask'.

	This displays the binary image mask at the given threshold 
	value. Now adjust the 'threshold' slider until you have 
	a reasonably well thresholded image.
.TP 3
3) click on 'both', and continue to adjust the threshold slider.

	This displays a blend of the image and the mask.
.TP 3
4) enter a mask file name, and click the 'save' button.

	This will save the mask you just created, under the
	file name you just entered.
.TP 3
5) click on 'edit'.

	This brings up a zoom/edit window. Click the mouse in 
	the view window to select to part of the image use wish
	to edit. The zoom is centered at the mouse location.
.TP 3
6) Hold down any mouse button in the zoom/edit window to paint 
	or erase. Try different brush sizes, zoom magnifications, 
	square vs. round cursors, etc.
.TP 3
7) click on 'save' to save your changes 
	(NOTE: both the main control and the edit control have SAVE
	and RESTORE buttons. Both buttons have the exact same effect,
	there are two of each for convenience only.)
.TP 3
8) make some changes in the mask, then click on 'restore'.
	This will undo all changes since the last 'save'.
.TP 3
9) Hold down the 'shift' key, and press any mouse button anywhere
	in the image.  This will display the gray value of the 
	pixel at the tip of the mouse.
.TP 3
10) click on 'mask', hold down the 'meta' key ('left' or 'right' on
	a Sun keyboard), and press a mouse button over any object.
	
	This will pop up a window of statistics for that object.
.TP 3
11) click the 'mask' button.
	This will clear the highlighted objects.
.TP 3
12) click the 'quit' button.

.\"=============================================================
.SH TUTORIAL #2
.TP 50
.B Editing an existing mask
.TP 3
1) create a binary image mask using some segmentation method. For
	example:  dog < in | scale | thresh 20 > out
.TP 3
2) type 'segal' <cr>  to bring up the control panel
.TP 3
3) enter the image and mask filenames, and click 'load'.
.TP 3
4) click 'edit'
	Now you can modify the image as described above.
.\"=============================================================
.SH TUTORIAL #3
.TP 50
.B Building a Polygon Mask
.TP 3
1) type: segal -i image -m mask_file
    where image is a HIPS image file, and mask_file 
    is the name that you want to give the mask.
.TP 3
2) click the 'polygon mask' check box, then select the 
    vertices for the polygon by clicking any mouse
    button in the image window.  Be sure to select the
    points in order. You can move a vertex by holding 
    down the mouse near an existing vertex and dragging 
    the mouse.
.TP 3
3) click the 'Show' button to show the polygon that you `
    have selected.  If you want to change the polygon, 
    click 'Clear' and start again.
.TP 3
4) when you are satisfied with the polygon, click 'Fill' to 
      fill in the polygon and create the mask.
.TP 3
5) click 'save'
	This saves your mask image file.	
.\"=============================================================
.SH TUTORIAL #4
.TP 50
.B Building a mask without an image
.TP 3
1) Type: segal -m maskfile <cr>
	This starts up segal and loads and displays an existing mask.
(NOTE: if you want to start with a blank mask, run 'genframe'
to create a blank mask. For example: genframe 0 256 256 > mask.new)
.TP 3
2) click 'edit'
	Now you can modify the image as described above.

.SH SUMMARY
.pp
This is not intended to be a complete demonstration of all of the 
features of 
.I segal. 
It is only a brief overview of some of the standard uses. After going 
through these tutorials, it is probably a good idea to just sit down
and try playing with all the different settings to see what happens.

.\"=============================================================
.SH AUTHOR
Brian Tierney, LBL        email: bltierney@lbl.gov
.SH "SEE ALSO"
segal(1)
