/*
 * main.c
 *
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 * $Id: main.c,v 4.0.1.1 91/11/26 21:11:33 cek Exp Locker: cek $
 *
 * $Log:	main.c,v $
 * Revision 4.0.1.1  91/11/26  21:11:33  cek
 * patch3: Define ENDCAPS for cylinder-capping.
 * 
 * Revision 4.0  91/07/17  14:29:30  kolb
 * Initial version.
 * 
 */
#include <stdio.h>
#ifdef SYSV
#include <memory.h>
#endif
#include "libcommon/common.h"

extern FILE *yyin;

#define usage(v)		fprintf(stderr,"usage: %s [oldfile]\n",v)

main(argc, argv)
int argc;
char **argv;
{
	if (argc > 2) {
		usage(argv[0]);
		exit(1);
	}

	if (argc == 2) {
		yyin = fopen(argv[1], "r");
		if (yyin == (FILE *)NULL) {
			fprintf(stderr,"Cannot open %s\n",argv[1]);
			exit(2);
		}
	} else
		yyin = stdin;
	printf("/* Converted by rsconvert */\n");
	printf("#define ENDCAPS\n");
	yyparse();
}	

char *
strsave(s)
char *s;
{
	extern voidstar Malloc();
	char *r;

	r = (char *)Malloc(strlen(s) + 1);
	strcpy(r, s);
	return r;
}

voidstar
Malloc(n)
unsigned n;
{
	voidstar r;
	extern voidstar malloc();

	r = malloc(n);
	if (r == (voidstar)NULL) {
		fprintf(stderr,"Out of memory allocating %d bytes.\n");
		exit(1);
	}
	return r;
}

voidstar
Calloc(nelem, elen)
unsigned nelem, elen;
{
	voidstar res;

	res = Malloc(nelem*elen);
	bzero(res, (int)nelem*elen);
	return res;
}
