/*
 * rle_raw.h - Definitions for rle_getraw/rle_putraw.
 * Copyright (c) 1986, Spencer W. Thomas
 */

#ifndef RLE_RAW_H
#define RLE_RAW_H

#include "u_code.h"

/*****************************************************************
 * TAG( rle_op )
 *
 * Struct representing one rle opcode.
 */
#ifndef c_plusplus
    typedef struct rle_op rle_op;
#endif

struct rle_op {
    int opcode;			/* one of RByteDataOp or RRunDataOp */
    int xloc;			/* X location this op starts at */
    int length;			/* length of run or data */
    union {
	rle_pixel * pixels;	/* for ByteData */
	int run_val;		/* for RunData */
    } u;
};

#ifdef USE_PROTOTYPES
    /*****************************************************************
     * TAG( rle_raw_alloc )
     * 
     * Allocate buffer space for use by rle_getraw and rle_putraw.
     */
    extern int
    rle_raw_alloc( rle_hdr *the_hdr, rle_op ***scanp, int **nrawp );

    /*****************************************************************
     * TAG( rle_raw_free )
     *
     * Free buffer space allocated by rle_raw_alloc.
     */
    extern void rle_raw_free( rle_hdr *the_hdr, rle_op **scanp, int *nrawp );

    /*****************************************************************
     * TAG( rle_getraw )
     * 
     * Get a raw scanline from the input file.
     */
    extern unsigned int
    rle_getraw( rle_hdr *the_hdr, rle_op *scanraw[], int nraw[] );

    /*****************************************************************
     * TAG( rle_freeraw )
     * 
     * Free all the pixel arrays in the raw scan struct.
     */
    extern void
    rle_freeraw( rle_hdr * the_hdr, rle_op *scanraw[], int nraw[] );

    /*****************************************************************
     * TAG( rle_putraw )
     *
     * Put raw scanline data to the output file.
     */
    extern void
    rle_putraw( rle_op **scanraw, int *nraw, rle_hdr *the_hdr );

    /*****************************************************************
     * TAG( rle_rawtorow )
     *
     * Convert raw data to "row" type scanline data.
     */
    extern void
    rle_rawtorow( rle_hdr *the_hdr, rle_op **scanraw, int *nraw,
		  rle_pixel **outrows );
#else
    /* Return value decls only.  See above for detailed declarations. */
    /* From rle_getraw.c. */
    extern unsigned int rle_getraw();
    extern void rle_freeraw();
    /* From rle_putraw.c. */
    extern void rle_putraw();
    /* From rle_raw_alc.c. */
    extern int rle_raw_alloc();
    extern void rle_raw_free();
    /* From rle_rawrow.c. */
    extern void rle_rawtorow();

#endif

#endif /* RLE_RAW_H */
