/*
 * float_to_exp.c - Convert floating point values to exponent bytes
 * 
 * Date:	Thu Oct 29 1987
 * Copyright (c) 1987, University of Utah
 */

#include <stdio.h>
#include "u_.h"
#include <math.h>

/*****************************************************************
 * TAG( float_to_exp )
 * 
 * Takes an array of count floating point numbers, and makes an array
 * of count+1 pixels out of it.
 */
void
float_to_exp( count, floats, pixels )
int count;
float * floats;
rle_pixel * pixels;
{
    register int i;
    int expon, max_exp = -2000;
    float * fptr = floats;
    double f_exp;

    /* Find largest exponent */
    /* Use "Block normalization":
     * ExpScan[x] is largest exponent of the three
     * color components.  Red/Grn/BluScan[1..3] are the
     * normalized color components.
     */

    for (i = 0; i < count; i++)
    {
	frexp( *fptr++, &expon );
	max_exp = (expon > max_exp) ? expon : max_exp;
    }

    /* Don't over/underflow */
    if (max_exp > 128) max_exp = 128;
    else
	if (max_exp < -127) max_exp = -127;

    f_exp = ldexp( 256.0, -max_exp );

    fptr = floats;
    for( i = 0; i < count; i++ )  /* Extra casts for broken HP compiler */
        *pixels++ = (rle_pixel) ((int)(*fptr++ * f_exp)); 

    /* Excess 127 exponent */
    *pixels = (rle_pixel) (max_exp + 127); 
}
