/* input_lex.l								    */
/*									    */
/* Copyright (C) 1989, Craig E. Kolb					    */
/*									    */
/* This software may be freely copied, modified, and redistributed,	    */
/* provided that this copyright notice is preserved on all copies.	    */
/* 									    */
/* There is no warranty or other guarantee of fitness for this software,    */
/* it is provided solely "as is".  Bug reports or fixes may be sent	    */
/* to the author, who may or may not act on them as he desires.		    */
/*									    */
/* You may not include this software in a program or other software product */
/* without supplying the source, or without informing the end-user that the */
/* source is available for no extra charge.				    */
/*									    */
/* $Id: input_lex.l,v 3.0.1.4 90/03/07 21:26:29 craig Exp $ */
%{
#include <stdio.h>
#ifdef SYSV
#include <string.h>
#else
#include <strings.h>
#endif
#include "typedefs.h"
#include "y.tab.h"
double atof();
char *strsave();
%}
alpha	[a-zA-Z]
special	[\.\_-]
digit	[0-9]
exp	[Ee][-+]?{digit}+
string	({alpha}|"/")({alpha}|{digit}|{special}|"/")*
%p 3000
%%
[ \t\n]			;
^#			{handlehash();}
"/*"			{skipcomments();}
adaptive		{return(tADAPTIVE);}
aperture		{return(tAPERTURE);}
background		{return(tBACKGROUND);}
blotch			{return(tBLOTCH);}
box			{return(tBOX);}
bump			{return(tBUMP);}
checker			{return(tCHECKER);}
cone			{return(tCONE);}
contrast		{return(tCONTRAST);}
cutoff			{return(tCUTOFF);}
cylinder		{return(tCYL);}
defend			{return(tENDDEF);}
define			{return(tSTARTDEF);}
directional		{return(tDIRECTIONAL);}
endfile			{return(tENDFILE);}
extended		{return(tEXTENDED);}
eyep			{return(tEYEP);}
fbm			{return(tFBM);}
fbmbump			{return(tFBMBUMP);}
focaldist		{return(tFOCALDIST);}
fog			{return(tFOG);}
fov			{return(tFOV);}
gloss			{return(tGLOSS);}
grid			{return(tGRID);}
heightfield		{return(tHEIGHTFIELD);}
jittered		{return(tJITTERED);}
light			{return(tLIGHT);}
list			{return(tLIST);}
lookp			{return(tLOOKP);}
marble			{return(tMARBLE);}
maxdepth		{return(tMAXDEPTH);}
mist			{return(tMIST);}
object			{return(tOBJECT);}
outfile			{return(tOUTFILE);}
plane			{return(tPLANE);}
point			{return(tPOINT);}
poly			{return(tPOLY);}
resolution		{return(tRESOLUTION);}
rotate			{return(tROTATE);}
samples			{return(tSAMPLES);}
scale			{return(tSCALE);}
screen			{return(tSCREEN);}
sphere			{return(tSPHERE);}
superq			{return(tSUPERQ);}
surface			{return(tSURFACE);}
texture			{return(tTEXTURE);}
transform		{return(tTRANSFORM);}
translate		{return(tTRANSLATE);}
triangle		{return(tTRIANGLE);}
up			{return(tUP);}
wood			{return(tWOOD);}
{string}		{yylval.c = strsave(yytext);
				return(tSTRING);}
[+-]?{digit}+		{yylval.i = atoi(yytext);
				return(tINT);}

[+-]?{digit}+"."{digit}*({exp})? |
[+-]?{digit}*"."{digit}+({exp})? |
[+-]?{digit}+{exp}		{yylval.d = atof(yytext); return(tFLOAT);}

.			{return yytext[0];}

%%
yywrap() {return(1);}
/*
 * Skip over comments.
 */
skipcomments()
{
	char c;

	while (1) {
		while (input() != '*')
			;
		if ((c = input()) == '/')
			return;
		unput(c);
	}
}
/*
 * Deal with ccp-produced lines of the form:
 * # n "filename"
 * and
 * # n
 * Where filename is the name of the file being processed, and n is
 * the current line number in that file.
 */
handlehash()
{
	char buf[BUFSIZ];
	int i;
	extern int yylineno;
	extern char yyfilename[];

	/*
	 * Read the entire line into buf.
	 */
	for (i = 0; (buf[i] = input()) != '\n'; i++)
			;
	unput(buf[i]);		/* To make sure consecutive # lines work. */
	buf[i] = (char)NULL;	/* Replace newline with NULL. */

	/*
	 * Complain if the line was not of the form #n "filename"
	 */
	if ((i = sscanf(buf, "%d \"%[^\"]s\"", &yylineno, yyfilename)) == 0) {
		yyerror("Unknown '#' control.");
		exit(1);
	}
	if (i == 1) {
#ifdef SYSV
		if (strchr(buf, '"') != (char *)0) {
#else
		if (index(buf, '"') != (char *)0) {
#endif
			/*
			 * Filename was "", which means stdin.
			 */
			strcpy(yyfilename, "stdin");
		}
	}
}
