/* torus.h,v 1.1.1.1 1995/02/27 07:38:37 explorer Exp */

/*
 * Copyright (C) 1990, 1991, Mark Polipec, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef TORUS_H
#define TORUS_H

#define GeomTorusCreate(a,b,p,n) GeomCreate((GeomRef)TorusCreate(a,b,p,n), \
					TorusMethods())

/*
 * Torus
 */
typedef struct {
  Float a;		/* tube radius */
  Float b;		/* swept radius */
  Float aa, bb;		/* squares of the above */
  Trans trans;		/* general<-->canonical transform */
  Float bounds[2][3];     /* bounds */
} Torus;

extern GeomRef  TorusCreate _PROTO((Float, Float, Vector *, Vector *));
extern int	TorusIntersect INTERSECT_PROTO;
extern int      TorusNormal NORMAL_PROTO;
extern void     TorusUV UV_PROTO;
extern void	TorusBounds BOUNDS_PROTO;
extern char	*TorusName NAME_PROTO;
extern void     TorusStats STATS_PROTO;
extern Methods	*TorusMethods METHODS_PROTO;
extern void     TorusMethodRegister _PROTO((UserMethodType));

#endif /* TORUS_H */
