/* poly.h,v 1.1.1.1 1995/02/27 07:38:35 explorer Exp */

/*
 * Copyright (C) 1989, 1991, Craig E. Kolb
 * All rights reserved.
 *
 * This software may be freely copied, modified, and redistributed
 * provided that this copyright notice is preserved on all copies.
 *
 * You may not distribute this software, in whole or in part, as part of
 * any commercial product without the express consent of the authors.
 *
 * There is no warranty or other guarantee of fitness of this software
 * for any purpose.  It is provided solely "as is".
 *
 */

#ifndef POLY_H
#define POLY_H

#define GeomPolygonCreate(r,p,f) GeomCreate((GeomRef)PolygonCreate(r,p,f), \
					PolygonMethods())

/*
 * Polygon
 */
typedef struct {
  Vector norm;		/* Normal to polygon */
  Float d;		/* Plane constant */
  char index;		/* Which normal coord is "dominant"? */
  Vector *points;	/* Array of vertices */
  int npoints;		/* Number of vertices */
} Polygon;

extern GeomRef  PolygonCreate _PROTO((PointList *, int, int));
extern Methods	*PolygonMethods METHODS_PROTO;
extern int	PolygonIntersect INTERSECT_PROTO;
extern int      PolygonNormal NORMAL_PROTO;
extern void     PolygonUV UV_PROTO;
extern void	PolygonBounds BOUNDS_PROTO;
extern char	*PolygonName NAME_PROTO;
extern void     PolygonStats STATS_PROTO;
extern void     PolygonMethodRegister _PROTO((UserMethodType));

#endif /* POLY_H */
