/* popen.c,v 1.1.1.1 1995/02/27 07:38:52 explorer Exp */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <exec/types.h>
#include <dos/dos.h>
#include <dos/dostags.h>
#ifdef __SASC
#include <proto/dos.h>
#endif
#ifdef __GNUC__
#include <inline/dos.h>
#endif

#ifndef AMIGA
static char template[] = "piXXXXXX";
#else
extern char *mktemp(char *);
#endif

typedef enum { unopened = 0, reading, writing } pipemode;
static
struct {
    char *command;
    char *name;
    pipemode pmode;
} pipes[FOPEN_MAX];

static struct TagItem Tags[] = {
  {NP_StackSize, 250000},
  {TAG_DONE, NULL}
};

FILE *
popen(const char *command, const char *mode ) {
    FILE *current;
    char *name;
    int cur;
    pipemode curmode;
#ifdef AMIGA
char template[] = "T:piXXXXXX";
#endif
    /*
    ** decide on mode.
    */
    if(strcmp(mode,"r") == 0)
        curmode = reading;
    else if(strcmp(mode,"w") == 0)
        curmode = writing;
    else
        return NULL;
    /*
    ** get a name to use.
    */
#ifdef AMIGA
    name = mktemp(template);
#else
    if((name = tempnam(".","pip"))==NULL)
        return NULL;
#endif
    /*
    ** If we're reading, just call system to get a file filled with
    ** output.
    */
    if(curmode == reading) {
        char cmd[256];
        sprintf(cmd,"%s > %s",command,name);
	SystemTagList(cmd, Tags);
        if((current = fopen(name,"r")) == NULL)
            return NULL;
    } else {
        if((current = fopen(name,"w")) == NULL)
            return NULL;
    }
    cur = fileno(current);
    pipes[cur].name = strdup(name);
    pipes[cur].pmode = curmode;
    pipes[cur].command = strdup(command);
    return current;
}

int
pclose( FILE * current) {
    int cur = fileno(current),rval;
    /*
    ** check for an open file.
    */
    if(pipes[cur].pmode == unopened)
        return -1;
    if(pipes[cur].pmode == reading) {
        /*
        ** input pipes are just files we're done with.
        */
        rval = fclose(current);
        unlink(pipes[cur].name);
    } else {
        /*
        ** output pipes are temporary files we have
        ** to cram down the throats of programs.
        */
        char command[256];
        fclose(current);
        sprintf(command,"%s < %s",pipes[cur].command,pipes[cur].name);
	rval = SystemTagList(command, Tags);
        unlink(pipes[cur].name);
    }
    /*
    ** clean up current pipe.
    */
    pipes[cur].pmode = unopened;
    free(pipes[cur].name);
    free(pipes[cur].command);
    return rval;
}

/* Special version of popen, to call the SAS/C preprocessor */
FILE *
popen2(const char *command) {
    FILE *current;
    char *name;
    int cur;
    char template[] = "T:piXXXXXX";
    char cmd[256], tmpname[256];
    char *fname, *fpart;
    BPTR l;
    /*
    ** get a name to use.
    */
    name = mktemp(template);
    /*
    ** We're reading, just call system to get a file filled with
    ** output.
    */
    fname = strrchr(command, ' ');
    *fname++ = 0;
    l = Lock(fname, ACCESS_READ);
    if (!l) return NULL;
    strcpy(tmpname, fname);
    fpart = FilePart(tmpname);
    *fpart = 0;
    strcat(tmpname, "__ray__.c");
    MakeLink(tmpname, l, 0);
    UnLock(l);
    sprintf(cmd,"%s OBJNAME %s %s",command,name,tmpname);
    cmd[strlen(cmd)-2] = '\0';
    SystemTagList(cmd, Tags);
    DeleteFile(tmpname);
    *--fname = ' ';
    if((current = fopen(name,"r")) == NULL)
	return NULL;
    cur = fileno(current);
    pipes[cur].name = strdup(name);
    pipes[cur].pmode = reading;
    pipes[cur].command = strdup(command);
    return current;
}
