#include <RpSampledImage.h>
#include <RpImageTile.h>
#include <RpMiniMan.h>
#include <assert.h>


RpMiniMan::RpMiniMan ( unsigned long ulRAM, unsigned long ulPixels )
: RpImageMan( ulRAM, ulPixels )
{
   return;
}


RpMiniMan::~RpMiniMan( void )
{
   return;
}



RpImageTile *
RpMiniMan::newTile( RpSampledImage *pCaller, const RpImageArea& area )
{
   RpImageTile		*pRet = 0;

   if ( pCaller )
   {
      pRet = RpImageTile::newTile( area, pCaller->getType() );
      
      if ( pRet )
	 decomposeRequest( pRet, pCaller );
   }
   
   return ( pRet );
}



void
RpMiniMan::calcDecomposition( const RpImageArea& area, unsigned& uXDiv, unsigned& uYDiv )
{
    unsigned long	uXResult, uYResult;

    uXDiv = 1;
    uYDiv = 1;

    uXResult = area.width;
    uYResult = area.height;


    while( (getTileBound() / uXResult ) < uYResult )
    {
       assert( uYResult && uXResult );

       if ( uXResult > uYResult )
       {
          ++uXDiv;
          uXResult = ( area.width / uXDiv );
       } else {
          ++uYDiv;
          uYResult = ( area.height / uYDiv );
       }
    }
    assert( uXResult && uYResult );
    return;
}



void
RpMiniMan::decomposeRequest( RpImageTile *pRet, RpSampledImage *pCaller )
{
   unsigned uXDiv, uYDiv;
   
   if ( pRet && pCaller )
   {
      calcDecomposition( pRet->getArea(), uXDiv, uYDiv );

      if ( (uXDiv==1) && (uYDiv==1) )
      {
         pCaller->fillTile( pRet );
      } else {      
         unsigned uLoopX, uLoopY;
         
         RpImageTile *pTemp;
         RpImageArea tempArea;
         
         assert( uXDiv && uYDiv );
         
         tempArea = pRet->getArea();
         for( uLoopY=0; uLoopY<uYDiv; uLoopY++ )
         {
            tempArea.x = pRet->getArea().x;
            tempArea.height = 
               (((uLoopY + 1) * pRet->getArea().height ) / uYDiv ) -
               ((uLoopY * pRet->getArea().height ) / uYDiv );
               
            for( uLoopX=0; uLoopX<uXDiv; uLoopX++ )
            {
               tempArea.width =
                  (((uLoopX + 1 ) * pRet->getArea().width) / uXDiv ) -
                  ((uLoopX * pRet->getArea().width ) / uXDiv );

               pTemp = RpImageTile::newTile( tempArea, pCaller->getType() );
               if ( pTemp )               
               {
                  if ( !(pCaller->fillTile( pTemp )) )
                  {
                     assert( pRet->getType() == pTemp->getType() );
                     tilecpy( *pRet, *pTemp, pTemp->getArea() );
                  } 
                  pTemp->deleteTile();
               }
                  
               tempArea.x += tempArea.width;               
            }
            
            tempArea.y += tempArea.height;
         }
      }
      
   }
   
   return;
}
