#include <RpFillPadding.h>
#include <RpSampledImage.h>
#include <RpType.h>

#include <assert.h>
#include <string.h> // memcpy()

RpFillPadding::RpFillPadding( float fChannelFill )
{

#define RpTYPEMACRO( typename, type, low, high, black, white, prec, func ) \
typename##brightness =  (type) \
   (( fChannelFill * ((float) white )) + \
   ( (1.0 - fChannelFill ) * (( float ) black ) ))
#include <RpType.m>

   return;
}



int
RpFillPadding::fillTile( RpSampledImage *pHost, RpImageTile *pWriteHere )
{
   int			iRet = 0;
   unsigned		uLoop;
   RpImageArea		imageMiss[8];
   RpImageArea		imageHit;
   RpImageArea		padStrip[4];
   RpImageArea		copyArea;

   if ( pHost && pWriteHere )
   {      
      //
      // pad in c
      //
      if(
          ( pWriteHere->getArea().c >= pHost->getArea().c ) ||
          ( pWriteHere->getArea().c < 0 )
      )
      {
         channelFill( pWriteHere, pWriteHere->getArea() );
      } else {

	 //
	 // determine tile areas in the image and outside the image.
	 //
	 imageHit = pHost->getArea();
	 imageHit.c = pWriteHere->getArea().c;
	 imageHit.z = pWriteHere->getArea().z;
	 imageHit = intersect( imageHit, pWriteHere->getArea() );
	 difference( imageMiss, pWriteHere->getArea(), imageHit );         
         
	 //
	 // pad in z
	 //
	 if ( pWriteHere->getArea().z < 0 )
	 {
	    imageHit.z = 0;
	    padFrame( pHost, pWriteHere, imageHit );
	 }
	 else
	    if ( pWriteHere->getArea().z >= pHost->getArea().z )
	    {
	       imageHit.z = pHost->getArea().z - 1;
	       padFrame( pHost, pWriteHere, imageHit );
            }
                        
	 //
	 // determine padding *strips* and the edges of the image
	 //
         setPadStrips( padStrip, imageHit );
         
	 //
	 // for each out-of-range (x,y) area:
	 //
	 uLoop = 8;
	 while ( uLoop )
	 {
            --uLoop;
            
            //
            // this conditional is an optimization:
            //
            if( imageMiss[uLoop].width && imageMiss[uLoop].height )
            {
               //
               // determine copy area
               //
               copyArea = imageHit;
               if ( imageMiss[uLoop].x < imageHit.x )
                  copyArea = intersect( copyArea, padStrip[3] );
               if ( imageMiss[uLoop].x >= (imageHit.x + (signed)imageHit.width))
                  copyArea = intersect( copyArea, padStrip[2] );
               if ( imageMiss[uLoop].y < imageHit.y )
                  copyArea = intersect( copyArea, padStrip[1] );
               if ( imageMiss[uLoop].y >= (imageHit.y + (signed)imageHit.height))
                  copyArea = intersect( copyArea, padStrip[0] );

               //
               // do copy
               //
               iRet |= fillPad( pWriteHere, imageMiss[uLoop], pHost, copyArea );
            }
	 }
      }
   }
   
   return( iRet );
}


void
RpFillPadding::channelFill( RpImageTile *pTile, const RpImageArea& area )
{
   signed	iY;
   unsigned	iWidth;
   
#define RpTYPEMACRO( typename, type, low, high, black, white, prec, func ) \
type * typename##buffer
#include <RpType.m>   
   
   assert( pTile );
   
   //
   // assert (area) is a subarea of pTile->getArea()
   //   
   switch( pTile->getType() )
   {
            
#define RpTYPEMACRO( typename, type, low, high, black, white, prec, func ) 		\
   case( typename ) :							\
      iY = area.y + (signed) area.height; 				\
      while ( iY > area.y ) {						\
         iY--;								\
         typename##buffer = ( type *) pTile->getBufferAt(area.x, iY);	\
         if ( typename##buffer ) { 					\
            iWidth = area.width;					\
            while( iWidth )						\
            { --iWidth;							\
               *( typename##buffer ) = typename##brightness;		\
               typename##buffer ++;					\
            }								\
         } 								\
      } break
#include <RpType.m>      
            
   };
  
   return;
}


void
RpFillPadding::padFrame( 
   RpSampledImage		*pHost,
   RpImageTile 			*pWriteHere,
   const RpImageArea& 		area
)
{
   RpImageTile 		*pTile;
   
   assert( pHost && pWriteHere );
   
   pTile = pHost->newTile( area );
   if ( pTile )
   {
      pTile->typecast( pWriteHere->getType() );
      tilecpy( *pWriteHere, *pTile, area );
      pTile->deleteTile();
   }
   
   return;
   
}


void
RpFillPadding::setPadStrips( RpImageArea padStrip[4], const RpImageArea& image )
{
   padStrip[ 0 ].x = image.x;
   padStrip[ 0 ].y = image.y + (signed) image.height - 1;
   padStrip[ 0 ].width = image.width;
   padStrip[ 0 ].height = 1;
   padStrip[ 0 ].z = image.z;
   padStrip[ 0 ].c = image.c;
   
   padStrip[ 1 ].x = image.x;
   padStrip[ 1 ].y = image.y;
   padStrip[ 1 ].width = image.width;
   padStrip[ 1 ].height = 1 ;
   padStrip[ 1 ].z = image.z;
   padStrip[ 1 ].c = image.c;
   
   padStrip[ 2 ].x = image.x + (signed) image.width - 1 ;
   padStrip[ 2 ].y = image.y;
   padStrip[ 2 ].width = 1;
   padStrip[ 2 ].height = image.height;
   padStrip[ 2 ].z = image.z;
   padStrip[ 2 ].c = image.c;
   
   padStrip[ 3 ].x = image.x;
   padStrip[ 3 ].y = image.y;
   padStrip[ 3 ].width = 1;
   padStrip[ 3 ].height = image.height;
   padStrip[ 3 ].z = image.z;
   padStrip[ 3 ].c = image.c;
   
   return;
}


int
RpFillPadding::fillPad(
   RpImageTile 			*pWriteHere,
   const RpImageArea&  		imageMiss,
   RpSampledImage 		*pHost,
   const RpImageArea& 		copyArea
)
{
    int		iRet = 0;
    RpImageTile	*pTile;
    
    assert( pWriteHere && pHost );
    if ( copyArea.width && copyArea.height )
    {
       pTile = pHost->newTile( copyArea );
       if ( pTile )
       {
	  pTile->typecast( pWriteHere->getType() );

	  if ( copyArea.width > 1 )
             copyRows( pWriteHere, imageMiss, pTile );
	  else
             if ( copyArea.height > 1 )
        	copyColumns( pWriteHere, imageMiss, pTile );
             else {
        	assert( (copyArea.width == 1) && (copyArea.height == 1) );
        	copyPixel( pWriteHere, imageMiss, pTile );
             }

	  pTile->deleteTile();
       }
    }    
    return( iRet );
}


void
RpFillPadding::copyRows( RpImageTile *pWriteHere, const RpImageArea& imageMiss, const RpImageTile *pSource )
{
   assert( pWriteHere && pSource );
   assert( imageMiss.width == pSource->getArea().width );
   assert( pWriteHere->getType() == pSource->getType() );
      
   unsigned uLoop;
   
   uLoop = imageMiss.height;
      
   while( uLoop )
   {
      --uLoop;
      
      memcpy(
         pWriteHere->getBufferAt( imageMiss.x, imageMiss.y + (signed)uLoop ),
         pSource->getBuffer(),
         pSource->getArea().width * bytesize( pSource->getType() )
      );      
   }
   
   return;
}


void
RpFillPadding::copyColumns( RpImageTile *pWriteHere, const RpImageArea& imageMiss, const RpImageTile *pSource )
{
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func ) \
   type * label##pDest ; \
   type * label##pSrc
#include <RpType.m>

   unsigned uHeight, uWidth;

   assert( pWriteHere && pSource );
   assert( imageMiss.height == pSource->getArea().height );   
   assert( pWriteHere->getType() == pSource->getType() );

   uHeight = imageMiss.height;
   
   while( uHeight )
   {
      --uHeight;
      
      uWidth = imageMiss.width ;
      
      switch( pWriteHere->getType() )
      {
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func ) \
      case( label ) : \
	 label##pSrc = ( type * ) pSource->getBufferAt( pSource->getArea().x, pSource->getArea().y + (signed) uHeight ); \
	 label##pDest = ( type * ) pWriteHere->getBufferAt( imageMiss.x, imageMiss.y + (signed) uHeight ); \
	 while ( uWidth ) { \
	    --uWidth; \
	    * label##pDest = * label##pSrc ; \
	    ++ label##pDest ; \
	 } break      
#include <RpType.m>
      };
   }

   return;
}


void
RpFillPadding::copyPixel( RpImageTile *pWriteHere, const RpImageArea& imageMiss, const RpImageTile *pSource )
{
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func ) \
   type * label##pDest ; \
   type * label##pSrc = ( type * )pSource->getBuffer()
#include <RpType.m>

   assert( pWriteHere && pSource );
   assert( pWriteHere->getType() == pSource->getType() );
      
   unsigned uHeight, uWidth;
   
   uHeight = imageMiss.height;
      
   while( uHeight )
   {
      --uHeight;
      
      switch( pWriteHere->getType() )
      {
#define RpTYPEMACRO( label, type, low, high, black, white, prec, func ) \
         case( label ): \
            uWidth = imageMiss.width; \
            label##pDest = ( type * )pWriteHere->getBufferAt( imageMiss.x, imageMiss.y + (signed)uHeight ) ; \
            while( uWidth ) { \
               --uWidth; \
               * label##pDest = * label##pSrc ; \
               ++ label##pDest ; \
            } break
#include <RpType.m>
      };      
   }
   
   return;
}
