#ifndef RpSGIReader_CLASS
#define RpSGIReader_CLASS
#include <RpSampledImage.h>
#include <RpBinaryBuffer.h>
#include <fstream.h>

// ************************************************************************
// CLASS: RpSGIReader 
// DESC:
//    This class implements a file reader for a SGI file format image
// NOTE:
//    This class may be used as a template for new file readers in the
//    short term, but eventually a file format system will be implemented
//    which require some changes.
//
class RpSGIReader : public RpSampledImage {
   public:
      enum Status {
         OK = 0,
         BadFilename,
         BadSGIFormat,
         RAMError,
         UnsupportedFeature,
         FileError
      };
         
   public:
      RpSGIReader( const char *cpFilename ); // open, setType() setArea()
      ~RpSGIReader( void ); // close
      
      int
      fillTile( RpImageTile *pWriteHere );
      
      float
      getCostEstimate( const RpImageArea& area )
      { return ( RpSampledImage::getCostEstimate( area ) * 2.0 ); }
      
      Status
      getStatus( void ) const
      { return ( _status ); }
      
   protected:
      int		_isRLE;
      Status		_status;
      ifstream		_fileStream;

      unsigned long	_lMax;
      unsigned long	_lMin;
      
      RpBinaryBuffer	_startTable;
      RpBinaryBuffer	_lengthTable;
      
      // 2 chars -> 1 short
      unsigned short
      castToShort( unsigned char *cp );
      
      // 4 chars -> 1 long
      unsigned long
      castToLong( unsigned char *cp );
      
      int
      seekRow( int iRow, int iChannel );
      
      void
      readRow( void *pDest, int iRow, int iChannel );
      
      void
      _decode8( unsigned char  *cp );
      
      void
      _decode16( unsigned short *sp );
};

#endif
