#ifndef RpMiniMan_CLASS
#define RpMiniMan_CLASS

#include <RpImageMan.h>

class RpImageTile;
class RpSampledImage;
// ************************************************************************
// CLASS: RpMiniMan
// DESC:
//    Implements a naive pull-through image processing engine.
// NOTE:
//    Use RpManReference to reference the current image manager.
//    Users should never need to instantiate an image manager directly.
//
class RpMiniMan : public RpImageMan {
   public:
      RpMiniMan ( unsigned long ulRAMBound, unsigned long ulTileBound );
      ~RpMiniMan( void );
      
      RpImageTile *
      newTile( RpSampledImage *pCaller, const RpImageArea& area );
      
      unsigned long
      getRAMSize( void ) const
      { return( 0 ); }
      
      void
      forceCache( RpSampledImage * )
      { return; }
      
      void
      flushCache( RpSampledImage * )
      { return; }
      
      void
      flushCache( void )
      { return; }
      
   private:
   
      void
      calcDecomposition( const RpImageArea& area, unsigned& uXDiv, unsigned& uYDiv );
      
      void
      decomposeRequest( RpImageTile *pRet, RpSampledImage *pCaller );

};

#endif
