#ifndef RpImageArea_STRUCT
#define RpImageArea_STRUCT

// ************************************************************************
// STRUCT:
//    Defines an area in image space.
//
typedef struct {
   signed x;
   signed y;
   signed c;
   signed z;
   unsigned width;
   unsigned height;
} RpImageArea;


// ************************************************************************
// DESC:
//    calculates the intersection of two areas, if they do intersect.
//
RpImageArea
intersect( const RpImageArea& area1, const RpImageArea& area2 );


// ************************************************************************
// DESC: decomposes the subtraction of (minusThis) from (area)
//       into 8 areas.
//
void
difference( RpImageArea writeHere[8], const RpImageArea& area, const RpImageArea& minusThis );

#endif

