#ifndef RpFillPadding_CLASS
#define RpFillPadding_CLASS
#include <RpFillStrategy.h>
#include <RpType.h>

// ************************************************************************
// CLASS : RpFillPadding
// DESC:
//    This fill strategy extends the edges of a sampled image
//    into out-of-range areas.  It extends the image in x,y and z;
//    but not in c.  This makes it useful for use with convolutions
//    to prevent edge artifacts - and the computation cost is reasonable.
//
class RpSampledImage;
class RpFillPadding : public RpFillStrategy
{
   public:
      RpFillPadding( float fChannelFill = 0.0 );
      ~RpFillPadding( void ){ }
      
      int
      fillTile( RpSampledImage *pHost, RpImageTile *pWriteHere );
      
   protected:
   
#define RpTYPEMACRO( typename, type, low, high, black, white, prec, func ) \
type typename##brightness
#include <RpType.m>   

      
   protected:

      void
      channelFill( RpImageTile *pWriteHere, const RpImageArea& area );
      
      void
      padFrame( RpSampledImage *pHost, RpImageTile *pWriteHere, const RpImageArea& area );

      void
      setPadStrips( RpImageArea paddingAreas[4], const RpImageArea& image );
      
      int
      fillPad( RpImageTile *pWriteHere, const RpImageArea& imageMiss, RpSampledImage *pHost, const RpImageArea& area );
      
      void
      copyRows( RpImageTile *pWriteHere, const RpImageArea& imageMiss, const RpImageTile *pSource );
      
      void
      copyColumns( RpImageTile *pWriteHere, const RpImageArea& imageMiss, const RpImageTile *pSource );
      
      void
      copyPixel( RpImageTile *pWriteHere, const RpImageArea& imageMiss, const RpImageTile *pSource );

};

#endif
