/*
 * Convert Leicester sky luminance data to Radiance input.
 */

#include <stdio.h>

#include <math.h>

#include "color.h"


#define  PI		3.14159265358979323846

#define  MAXLUMINANCE	60000.0
#define  LUMERR		99997.5

#define  MAXSAMP	30
#define  NROWS		8

short  nv_row[NROWS] = {30, 30, 24, 24, 18, 12, 6, 6};


main(argc, argv)
int	argc;
char	**argv;
{
	char	fbuf[64];
	int	day, year, hour, minute;
	double	v[3], d;
	double	sill, salt, sazi;

	if (argc == 3 && !strcmp(argv[1], "-s"))
		sill = atof(argv[2]);
	else
		sill = 0.0;

	while (scanf("%d %d %d %d %lf %lf", &day, &year, &hour, &minute,
			&salt, &sazi) == 6) {
		sprintf(fbuf, "%03d_%02d_%02dh%02d.dat", day,year,hour,minute);
		printf("\nvoid brightdata sky%03d_%02d_%02dh%02d\n",day,year,hour,minute);
		printf("5 noneg %s . Asin(Dz)/DEGREE ", fbuf);
		printf("mod(atan2(Dx,Dy)/DEGREE-%g,360)\n", sazi);
		printf("0\n0\n");
		cvdata(fbuf);
	}
	if (sill > 0.0) {
		salt *= PI/180.0;
		sazi *= PI/180.0;
		v[0] = cos(salt);
		v[1] = v[0]*cos(sazi);
		v[0] *= sin(sazi);
		v[2] = sin(salt);
		d = sill/1.904e-5/WHTEFFICACY/PI;
		printf("\nvoid light solar\n");
		printf("0\n0\n3 %f %f %f\n", d, d, d);
		printf("\nsolar source sun\n");
		printf("0\n0\n4 %f %f %f 0.5\n", v[0], v[1], v[2]);
            printf("\nsky%03d_%02d_%02dh%02d",day,year,hour,minute);
            printf(" glow sky_glow\n");
            printf("0\n0\n4 1 1 1 0\n");
            printf("\nsky_glow source sky\n");
            printf("0\n0\n4 0 0 1 180\n");
	}
	exit(0);
}


cvdata(fname)			/* convert data to Radiance format */
char	*fname;
{
	double	row[MAXSAMP];
	int	i;
	register int	j;
	FILE	*fp;

	if ((fp = fopen(fname, "w")) == NULL) {
		perror(fname);
		exit(1);
	}
	fprintf(fp, "2\n6 90 %d\n0 360 %d\n", NROWS, MAXSAMP+1);
	for (i = 0; i < NROWS; i++) {
		for (j = 0; j < nv_row[i]; j++) {
			if (scanf("%lf", &row[j]) != 1) {
				fprintf(stderr, "%s: data format error\n",
						fname);
				exit(1);
			}
			if (row[j] >= LUMERR)	/* overrange */
				row[j] = j ? row[j-1] : MAXLUMINANCE;
		}
		if (i == NROWS-1) {		/* average zenith values */
			for (j = 1; j < nv_row[i]; j++)
				row[0] += row[j];
			row[0] /= (double)nv_row[i];
			cvrow(row, 1, fp);
		} else
			cvrow(row, nv_row[i], fp);
	}
	putc('\n', fp);
	if (fclose(fp) == -1) {
		perror(fname);
		exit(1);
	}
}


cvrow(rp, n, fp)		/* resample and print row to fp */
register double	*rp;
int	n;
FILE	*fp;
{
	double  nrow[MAXSAMP+1];
	double  x;
	register int	i, j;
					/* resample row if necessary */
	if (n < MAXSAMP)
		for (i = 0; i < MAXSAMP; i++) {
			j = x = (double)i*n/MAXSAMP;
			if (j > n-2)
				j = n-2;
			x -= (double)j;
			nrow[i] = rp[j]*(1.-x) + rp[j+1]*x;
		}
	else
		for (i = 0; i < MAXSAMP; i++)
			nrow[i] = rp[i];
	nrow[MAXSAMP] = rp[0];
					/* print full row */
	for (i = 0; i <= MAXSAMP; i++) {
		if (i%5 == 0)
			putc('\n', fp);
		fprintf(fp, " %4.4f", nrow[i]/WHTEFFICACY);
	}
}

