#ifndef lint
static       char    rcsid[] = "$Header: layer.c,v 1.1 90/06/17 03:34:51 zhang Exp $";
#endif

/*
 * $Log:	layer.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 */

#include "defs.h"

/*
 * insert a layer name into a layer list
 * return a pointer to the layer data structure
 */

LAYER	*LayerInsert(layerlist, layername)
LAYER	**layerlist;
CHAR	*layername;
{
	LAYER	*layer;

	if (*layerlist == NULL) {
		*layerlist = Malloc(LAYER, 1);
		(*layerlist)->name = Malloc(CHAR, strlen(layername) + 1);
		(VOID) strcpy((*layerlist)->name, layername);
		return((*layerlist));
	}

	for (layer = *layerlist; layer != NULL; layer = layer->next)
		if (strcmp(layer->name, layername) == 0)
			return(layer);
		else
		if (layer->next == NULL) {
			layer->next = Malloc(LAYER, 1);
			layer = layer->next;
			layer->name = Malloc(CHAR, strlen(layername) + 1);
			(VOID) strcpy(layer->name, layername);
			return(layer);
		}

	DXFERR("LayerInsert failure %s", "\n");
	/*NOTREACHED*/
}

/*
 * insert an entity into the given layer
 * note: the entity should not be in other entity list
 *
 * this function is not used as the entities are not resorted according to
 * their layer names
 */

/*ARGSUSED*/
VOID	EntityInsertToLayer(entity)
ENTITY	*entity;
{
	/*
	 * LAYER	*layer;
	 * ENTITY	*ent;
	 *
	 * layer = entity->layer;
	 * entity->next = NULL;
	 *
	 * if (layer->entitylist == NULL)
	 * 	layer->entitylist = entity;
	 * else {
	 * 	for (ent = layer->entitylist; ent->next != NULL; ent = ent->next)
	 *
	 * 		;
	 * 	ent->next = entity;
	 * }
	 */
}

/*
 * parse a layer name
 */

LAYER	*LayerDxfParse(layerlist)
LAYER	**layerlist;
{
	GetNextGroup();

	if (Group->code != 8)
		DXFERR("expect layer group (8) but get %d\n", Group->code);

	return(LayerInsert(layerlist, Group->string));
}
