#ifndef lint
static       char    rcsid[] = "$Header: check.c,v 1.1 90/06/17 03:34:51 zhang Exp $";
#endif

/*
 * $Log:	check.c,v $
 * 
 * Revision 1.1  90/06/17  03:34:51  zhang
 * Initial revision
 * 
 */

#include "defs.h"

/*
 * calculate plane equation of a polygon
 */

VOID	PlaneEquation(n, p, a, b, c, d)
INT	n;
FLOAT	p[][3];
FLOAT	*a, *b, *c, *d;
{
	INT	i, j, k;
	FLOAT	x, y, z, l;
	FLOAT	dx0, dy0, dz0, dx1, dy1, dz1;

	x = y = z = 0.0;
	for (i = 0; i < n; i++) {
		j = i - 1;
		k = i + 1;
		if (j < 0)
			j = n - 1;
		if (k >= n)
			k = 0;
		dx0 = p[j][0] - p[i][0];
		dy0 = p[j][1] - p[i][1];
		dz0 = p[j][2] - p[i][2];
		dx1 = p[k][0] - p[i][0];
		dy1 = p[k][1] - p[i][1];
		dz1 = p[k][2] - p[i][2];

		x += dy0 * dz1 - dz0 * dy1;
		y += dz0 * dx1 - dx0 * dz1;
		z += dx0 * dy1 - dy0 * dx1;
	}

	x /= (FLOAT) n;
	y /= (FLOAT) n;
	z /= (FLOAT) n;
	l = (FLOAT) sqrt(x * x + y * y + z * z);
	
	if (fabs(l) < TOE) {
		*a = *b = *c = *d = 0.0;
		return;
	}
	
	*a = -x / l;
	*b = -y / l;
	*c = -z / l;
	*d = -((*a) * p[0][0] + (*b) * p[0][1] + (*c) * p[0][2]);
}

/*
 * check if a point is in the positive side of a plane
 * if true, return 1, else 0
 */

INT	CheckDirection(npoints, polygon, point)
INT	npoints;
FLOAT	polygon[][3];
FLOAT	point[3];
{
	FLOAT	x, y, z;
	FLOAT	a, b, c, d;

	PlaneEquation(npoints, polygon, &a, &b, &c, &d);
	x = point[0] - polygon[0][0];
	y = point[1] - polygon[0][1];
	z = point[2] - polygon[0][2];

	if (a * x + b * y + c * z > 0.0)
		return(1);
	else
		return(0);
}

/*
 * check if a layer name has an "_I" suffix
 * if true, return 1, else 0
 */

INT	CheckLayerName(layer)
LAYER	*layer;
{
	INT	length;

	length = strlen(layer->name);

	if (length > 2)
		if (layer->name[length - 2] == '_' &&
		    layer->name[length - 1] == 'I')
		    	return(1);
		else
			return(0);
	return(0);
}

/*
 * reverse the vertex order of a polygon
 */

VOID	ReversePolygon(n, p)
INT	n;
FLOAT	p[][3];
{
	INT	i, j;
	FLOAT	temp[3];

	for (i = 0, j = n - 1; i < j; i++, j--) {
		VecCopy(p[i], temp);
		VecCopy(p[j], p[i]);
		VecCopy(temp, p[j]);
	}
}

/*
 * check the orientation of a polygon
 * with the reference point of its layer (if there is)
 * and reverse the order of the vertices of the polygon if necessary
 * return 1 if orientation is changed, else 0
 */

INT	CheckOrientation(n, p, layer)
INT	n;
FLOAT	p[][3];
LAYER	*layer;
{
	INT	pointflag;
	FLOAT	a, b, c, d;

	/*
	 * if there is a reference point
	 */

	if (layer->point == NULL)
		return(0);

	PlaneEquation(n, p, &a, &b, &c, &d);

	pointflag = CheckDirection(n, p, layer->point);

	if (CheckLayerName(layer) == 0) {

		/*
		 * layer name has no "_I"
		 */

		if (pointflag == 0) {

			/*
			 * reference point in the negative side
			 */

			ReversePolygon(n, p);
			return(1);
		}

		return(0);
	} else {
		/*
		 * layer name has no "_I"
		 */

		if (pointflag != 0) {

			/*
			 * reference point in the positive side
			 */

			ReversePolygon(n, p);
			return(1);
		}

		return(0);
	}
}
