/* vertexlist.h: lineaire lijsten van VERTEX structuren */

#ifndef _VERTEXLIST_H_
#define _VERTEXLIST_H_

#include "vertex.h"
#include "List.h"

typedef struct VERTEXLIST {
	struct VERTEX *vertex;
	struct VERTEXLIST *next;
} VERTEXLIST;

#define VertexListCreate	(VERTEXLIST *)ListCreate

#define VertexListAdd(vertexlist, vertex)	\
        (VERTEXLIST *)ListAdd((LIST *)vertexlist, (void *)vertex)

#define VertexListCount(vertexlist) \
        ListCount((LIST *)vertexlist)

#define VertexListGet(vertexlist, index) \
        (VERTEX *)ListGet((LIST *)vertexlist, index)

#define VertexListNext(pvertexlist) \
        (VERTEX *)ListNext((LIST **)pvertexlist)

#define VertexListRemove(vertexlist, vertex) \
        (VERTEXLIST *)ListRemove((LIST *)vertexlist, (void *)vertex)

#define VertexListIterate(vertexlist, proc) \
        ListIterate((LIST *)vertexlist, (void (*)(void *))proc)

#define VertexListDestroy(vertexlist) \
        ListDestroy((LIST *)vertexlist)

extern struct VERTEX *VertexListFind(VERTEXLIST *vl, POINT *p, VECTOR *norm);

#endif /* _VERTEXLIST_H_ */
