/**************************************************************************
  Copyright (C) 1992 Guy Moreillon
  All rights reserved.

  This software may be freely copied, modified, and redistributed
  provided that this copyright notice is preserved on all copies.

  You may not distribute this software, in whole or in part, as part of
  any commercial product without the express consent of the authors.

  There is no warranty or other guarantee of fitness of this software
  for any purpose.  It is provided solely "as is".
**************************************************************************/
/**************************************************************************

				RAD
		       (Interactive Radiosity)
		    	    Version 1.0
			       1992		    	    
		    	    
		  
		    	  Guy Moreillon
		    	  
**************************************************************************/

/**************************************************************************
  Fichier	: walkthru.c
  Description	: Routines de management du walkthrough
**************************************************************************/

#include <stdio.h>
#include "types.h"
#include "macros.h"
#include "misc.h"
#include "interface.h"
#include "walkthru.h"

void build_rotation_y(float da, Matrix matrix)
/**************************************************************************
  But	: Construit une matrice de rotation de da radians autour du y du
	  repere global
  Entree: da	    : angle de rotation autour de y
	  matrix    : matrice rendue
  Sortie: neant
**************************************************************************/
{
  float cosa = cos(da), sina = sin(da);

  M4D_init(matrix,  cosa, 0.0,  sina, 0.0,
		     0.0, 1.0,   0.0, 0.0,
		   -sina, 0.0,  cosa, 0.0,
		     0.0, 0.0,   0.0, 1.0);
}

void build_rotation_x(float db, Matrix matrix)
/**************************************************************************
  But	: Construit une matrice de rotation de db radians autour de x
  Entree: db	    : angle de rotation autour de x
	  matrix    : matrice rendue
  Sortie: neant
**************************************************************************/
{
  float cosb = cos(db), sinb = sin(db);

  M4D_init(matrix, 1.0,   0.0,   0.0, 0.0,
		   0.0,  cosb, -sinb, 0.0,
		   0.0,  sinb,	cosb, 0.0,
		   0.0,   0.0,	 0.0, 1.0);
}

void build_translation(float step, Matrix matrix)
/**************************************************************************
  But	: Construit une translation dans la direction z de l'observateur
	  d'une distance de step
  Entree: step	    : distance a parcourir
	  matrix    : matrice rendue
  Sortie: neant
**************************************************************************/
{
  M4D_init(matrix, 1.0, 0.0,   0.0, 0.0,
		   0.0, 1.0,   0.0, 0.0,
		   0.0, 0.0,   1.0, 0.0,
		   0.0, 0.0, -step, 1.0);
}

