/**********************************************************************/
/* misc.h : miscellaneous variables and constants                     */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#ifndef MISC_H
#define MISC_H

/* Miscellaneous constants */
#ifndef ERROR
#define ERROR -1
#endif /* ERROR */

#ifndef OK
#define OK 1
#endif /* OK */

#ifndef TRUE
#define TRUE 1
#endif /* TRUE */

#ifndef FALSE
#define FALSE 1
#endif /* FALSE */

#ifndef NULL
#define NULL 0
#endif /* NULL */

/**********************************************************************/

#define X 0
#define Y 1
#define Z 2
#define ANGLE_SHOCK_ABSORBER (0.4)
#define COORD_SHOCK_ABSORBER (0.04)
#define MIN_VECTOR_LENGTH    (1.0e-7)      /* min length of a vector */
#define UP	1                          /* define up / down direction */
#define DOWN	2
#define UNIVERSE         (1e10)            /* maximum environment size */
#define MAX_RESOLUTION   (4096)            /* maximum screen resolution */

#define VERY_SMALL       (1e-5)
#define DAMN_SMALL       (1e-10)
#define VERY_LARGE       (1e+5)
#define DAMN_LARGE       (1e+10)
#define PI               (3.14159265358979323846)
#define HALFLIFE         (-.69314718)

#define ABS(x)           (((x) > 0) ? (x) : (0 - (x)))
#define FABS(a)		 (((a) >= 0.0) ? (a): (-a))
#define SCAN_INT(a,b)	 (a == NULL ? 0 : sscanf(a,"%ld",b))
#define FLOOR(a)	 ((a)>0 ? (int)(a) : -(int)(-a))
#define CEILING(a)  ((a)==(int)(a) ? (a) : (a)>0 ? 1+(int)(a) : -(1+(int)(-a)))
#define ROUND(a)	((a)>0 ? (int)(a+0.5) : -(int)(0.5-a))		
#define ZSGN(a)		(((a)<0) ? -1 : (a)>0 ? 1 : 0)	/* sign of -1,0,1 */
/* take binary sign of a, either -1, or 1 if >= 0 */
#define SGN(a)		(((a)<0) ? -1 : 0)
/* shout if something that should be true isn't */
#define ASSERT(x) \
if (!(x)) fprintf(stderr," Assert failed: x\n");
/* square a */
#define SQR(a)		((a)*(a))	

#define MIN(a,b)	(((a)<(b))?(a):(b))	
#define MAX(a,b)	(((a)>(b))?(a):(b))	
#define SWAP(a,b)	{ a^=b; b^=a; a^=b; }
/* linear interpolation from l (when a=0) to h (when a=1)*/
/* (equal to (a*h)+((1-a)*l) */
#define LERP(a,l,h)	((l)+(((h)-(l))*(a)))
/* clamp the input to the specified range */
#define CLAMP(v,l,h)	((v)<(l) ? (l) : (v) > (h) ? (h) : v)

#define MAX_ARG		25
#define CONTINUE 0
#define DIE 1

#endif /* MISC_H */
