/**********************************************************************/
/* rtime.h : Timing routines                                          */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#ifndef RTIME_H
#define RTIME_H

typedef struct {
  float avg_ray;          /* Average time per ray-intersection test */
  float avg_shaft;        /* Average time per shaft building */
  float avg_ff;           /* Average time per form factor */
  float avg_iter;         /* Average time per iteration */
  float tot_time;         /* Total time for whole thing */
  float cur_time;         /* Current and last time */
  float last_time;    
  float prep_pHBV;        /* Preprocessing time to build polygon HBV */
  float prep_oHBV;        /* Preprocessing time to build object HBV */
  float prep_Model;       /* Preprocessing time to build model */
  float utime, stime;     /* User time and system time */
} Time_Stats;  

extern float Cpu_Time();
extern float Elapsed_Time();
extern void Init_Time();
extern void Print_Times();

#endif /* RTIME_H */
