/**********************************************************************/
/*                                                                    */
/* args.c : handle command line args                                  */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "geo.h"
#include "struct.h"
#include "rad.h"
#include "io.h"
#include "ff.h"
#include "misc.h"
#include "vcr.h"

#define shift argc--; argv++;
extern FF_OptionType FF_Options;
extern OptionType Option;
extern char *ProgName;
int test_vtxshade = 0;
int test_optik = 0;
int intermed[4] = { -1, -1, -1, -1 }; /* Intermediate results to store */
int num_inter = 0;

/**********************************************************************/
static char StrUsage[] =              /* program usage                */
  "[-dhsONV] -p file -v eye (-f 0/1 0/1/2)\n\t (-R 0/1 samples) [-I n i1..in]";

/**********************************************************************/
/* Syntax                                                             */
/**********************************************************************/
void Usage()
{
  fprintf(stderr,"usage: %s %s\n", ProgName, StrUsage);
}

/**********************************************************************/
/* Help                                                               */
/**********************************************************************/
void LongUsage()
{
  fprintf(stderr,"\nWhere:\n");
  fprintf(stderr,"\td : Set debug mode\n");
  fprintf(stderr,"\tf : 0/1 = hemicube/ray cast ffs\n");
  fprintf(stderr,"\t    0/1/2 = circle/ellipse/analyt ffs\n");
  fprintf(stderr,"\tp : Set patch input file\n");
  fprintf(stderr,"\ts : Statistics: 0/1 = stdout or to file\n");
  fprintf(stderr,"\tI : Storage of intermediate results\n");
  fprintf(stderr,"\t    n = number of places (max=4), i_n = iteration #\n");
  fprintf(stderr,"\tO : 0/1 = output to Optik output or not\n");
  fprintf(stderr,"\tR : 0/1 s = (don't) ray cast with s samples\n");
  fprintf(stderr,"\tN : Set to NTSC window mode\n");
  fprintf(stderr,"\tV : Record to VCR in NTSC mode\n");
  fprintf(stderr,"\th : This message\n");
}

/**********************************************************************/
/* Parse command line arguments                                       */
/**********************************************************************/
void ParseArgs(argc, argv)
     int argc;
     char **argv;
{
  char *env_var = "                    ";
  int enough_args = 0;
  int i;

  ProgName = argv[0];
  if (argc < 2) {
    Usage();
    exit(1);
  }

  shift;
  while (argc && **argv == '-') {
    switch(*++*argv) {

    case 'I':                    /* Output intermediate results up to 4 */
      shift;
      if (argc < 2) {
	fprintf(stderr,"Not enough I parameters\n");	
	exit(1);
      }
      num_inter = atoi(*argv);
      if (num_inter > 4) {
	fprintf(stderr,"Current maximum intermediate results is four\n");
	exit(1);
      }
      if (argc < num_inter || num_inter <= 0) {
	fprintf(stderr,"Incorrect I parameters\n");	
	exit(1);
      }
      for (i=0;i<num_inter;i++) {
	shift;
	if (!argc) {
	  fprintf(stderr,"Not enough I parameters\n");	
	  exit(1);
	}	  
	intermed[i] = atoi(*argv);
      }
      /* for (i=0;i<num_inter;i++) {
	 printf("intermed = %d\n",intermed[i]);
	 } */
      break;

    case 'N':                    /* Set NTSC window size and placement */
      if ((env_var = getenv("HOSTTYPE")) != 0)
	if (strcmp("iris4d",env_var) == 0) {
	  Option.VCRmode = NTSC;
	  Option.UseVCR = TRUE;
	  fprintf(stderr,"Displaying NTSC mode\n");
	} else {
	  Option.UseVCR = FALSE;
	  fprintf(stderr,"Sorry can't video run on a %s\n", env_var);
	  exit(1);
	}
      break;

    case 'O':                    /* Optik output or not ? */
      shift;
      if (argc < 1) {
	fprintf(stderr,"Not enough O parameters\n");	
	exit(1);
      }
      test_optik = atoi(*argv);
      break;

    case 'R': 
      shift;
      if (argc < 2) {
	fprintf(stderr,"Not enough ray parameters\n");	
	exit(1);
      }
      /* Really ray cast */
      if (atoi(*argv) == 1) 
	Option.visibility = FORM_FACTOR; 
      shift;

      /* This many samples */
      if ((atoi(*argv) == 1) || (atoi(*argv) == 4) || (atoi(*argv) == 16)) {
	FF_Options.num_samples = atoi(*argv);
	/* printf("samples = %d\n", FF_Options.num_samples); */
      }
      enough_args++;
      break;

    case 'T':                    /* Test of vertex shading (not used) */
      test_vtxshade = 1;
      break;

    case 'V':                    /* Run in NTSC mode */
      if ((env_var = getenv("HOSTTYPE")) != 0)
	if (strcmp("iris4d",env_var) == 0) {
	  Option.VCRmode = REC;
	  Option.UseVCR = TRUE;
	  Option.debug = FALSE;
	  Option.statistics = FALSE;
	  fprintf(stderr,"Recording in NTSC mode\n");
	} else {
	  Option.UseVCR = FALSE;
	  fprintf(stderr,"Sorry can't run video on a %s\n", env_var);
	  exit(1);
	}  
      break;

    case 'd':                     /* Run in debug mode */
      fprintf(stderr,"In debug mode\n");
      Option.debug = TRUE;
      break;
      
    case 'f': /* ray cast or hemicube ffs */
      shift;
      if (argc < 2) {
	fprintf(stderr,"Not enough ff parameters\n");	
	exit(1);
      }

      /* Hemicube =0, or ray cast = 1 */
      if ((atoi(*argv) == 0) || (atoi(*argv) == 1)) {
	Option.ff_raytrace = atoi(*argv); shift;
	/* printf("hc/rt = %d\n", Option.ff_raytrace); */
      } else {
	fprintf(stderr,"Incorrect ff parameters\n");	
	exit(1);
      }

      /* 0 = circle, 1=ellipse, 2=analytic */
      if (atoi(*argv) == 0) 
	FF_Options.sample_shape = DISC_FF;
      else if (atoi(*argv) == 1) 
	FF_Options.sample_shape = ELLIPSE_FF;
      else if (atoi(*argv) == 2) {
	FF_Options.sample_shape = DISC_FF;
	FF_Options.fftype = ANALYTIC_FF;
      }

      if ((atoi(*argv) < 0) || (atoi(*argv) > 2)) {
	fprintf(stderr,"Incorrect ff parameters\n");	
	exit(1);
      } else {
	/* printf("shape = %d\n", FF_Options.sample_shape);
	   printf("type = %d\n", FF_Options.fftype); */
      }
      enough_args++;
      break;

    case 'h':                    /* Help */
      Usage();
      LongUsage();
      exit(0);
      break;

    case 'p':                    /* Patch file name */
      shift;
      if (!argc) {
	fprintf(stderr,"No patch filename given\n"); 
	exit(1);
      }
      env_var = *argv;
      Option.meshfilename = env_var;
      /* printf("Mesh = %s\n", Option.meshfilename); */
      enough_args++;
      break;

    case 's':                     /* Statistics  */
      shift;
      if (argc < 1) {
	fprintf(stderr,"Not enough stat parameter\n");	
	exit(1);
      }	
      Option.statistics = TRUE;

      /* Stdout = 0, or File = 1 */
      if (atoi(*argv) == 0)	  Option.device = PRINT;
      else if (atoi(*argv) == 1)  Option.device = FILES;
      else {
	fprintf(stderr,"Incorrect stat output parameter\n");	
	exit(1);
      }
      fprintf(stderr,"Statistics sent to %s.\n",
	      (Option.device == PRINT ? "terminal" : "file"));
      break;

      /* case 'P': */                    /* Directory containing patch files */
      /* Option.data_dir = ".";
	 fprintf(stderr,"Set patch directory to current. Not done yet.\n"); 
      break; */

    case 'v':                    /* Patch file name */
      shift;
      if (!argc) {
	fprintf(stderr,"No view filename given\n");
	exit(1);
      }
      env_var = *argv;
      Option.viewfilename = env_var;
      enough_args++;
      break;
      
    default:
      Usage();
      exit(-1);
    }
    shift;
  }

  /* Check for enough args */
  if (enough_args < 4) {
    Usage();
    exit(1);
  }
}
