%{
/**********************************************************************/
/* parser.y                                                           */
/*                                                                    */
/* Copyright (C) 1992, Bernard Kwok                                   */
/* All rights reserved.                                               */
/* Revision 1.0                                                       */
/* May, 1992                                                          */
/**********************************************************************/
#include <stdio.h>
#include <ctype.h>
#include "qm2patch.h"

float floatvalue;
int readVector;		/* TRUE if parser is reading a vector */
int readMatrix = FALSE;	/* TRUE if parser is reading a matrix */
int elementVector;	/* current element of the vector read */
int rowMatrix;		/* current row of a matrix read */
int columnMatrix;	/* current column of a matrix read */
int lineno;

/* Surface variables */
int readSurfaceParm = FALSE; /* TRUE if parser is reading a surface parm */
int readCurve = FALSE;  /* TRUE if parser is reading curves of surface */
int Surfparm_read = 0;  /* Number of surface parameters read */
int pts_on_curve_read = 0; /* Number of curve points read per curve */
int curves_read = 0;    /* Number of curves read per surface */
int pts_per_curve = 0;  /* Total number of pts per curve */
int total_num_curves = 0; /* Total number of curves per surface */

/**********************************************************************/
extern float SurfaceParm[];    /* Surface parameters */
                               /* 0=pts/curve, 1=curves/surf*/
extern surface  SurfaceRead;   /* Surface to read */
extern vector	VectorRead;    /* Vector to read */
extern matrix	MatrixRead;    /* Matrix to read */
extern float	value;

extern void Surface();
extern void Init_Matrix();
extern void Scale();
extern void Translate();
extern void Rotate();
extern void Cone();
extern void Cube();
extern void Cylinder();
extern void Sphere();
extern void Light();
extern void SurfColour();
extern void Diffusion();
extern void Specularity();
%}
%token MODEL
%token TM
%token SCALE
%token TRANSLATE
%token ROTATE
%token SURFACE
%token CURVE
%token CONE
%token CUBE
%token CYLINDER
%token SPHERE
%token LIGHT
%token COLOR
%token DIFFUSION
%token SPECULARITY
%token LEFT_CURLY
%token RIGHT_CURLY
%token LEFT_ROUND
%token RIGHT_ROUND
%token SEMI_COLON
%token COMA
%token FLOAT
%%

scene: /* empty scene */ | object scene ;
object: MODEL body ;
body: LEFT_CURLY statements RIGHT_CURLY ;
statements: /* empty statement */ | statement statements ;
statement: transformation | primitive | property | surface ;
transformation:	tm | scale | translate | rotate ;

surface: flag_surf surfparm LEFT_CURLY curves RIGHT_CURLY
{
  readSurfaceParm = FALSE;
  readCurve = FALSE;
  Surface();
};

flag_surf: SURFACE {
  /* Is a surface. Get ready to read surface parameters and curves. */
  readSurfaceParm = TRUE;
  readCurve = FALSE;
  Surfparm_read = 0;
  pts_on_curve_read = 0;
  curves_read = 0;
  pts_per_curve = 0;
  total_num_curves = 0;
  SurfaceParm[0] = 0;
  SurfaceParm[1] = 0;
}; 

surfparm: LEFT_ROUND float COMA float RIGHT_ROUND SEMI_COLON 
{
  readSurfaceParm = FALSE;     /* Finished reading surface parameters */
  readCurve = TRUE;            /* reading surface now                 */
};

curves: | curve curves ;

curve: flag_curve curveparm

flag_curve: CURVE {
  elementVector = 0;
}; 

curveparm : LEFT_ROUND float COMA float COMA float COMA float COMA float RIGHT_ROUND SEMI_COLON {
  pts_on_curve_read = (pts_on_curve_read + 1) % pts_per_curve;
  if (pts_on_curve_read == 0)
    curves_read++;
  if (curves_read == total_num_curves) {
    readCurve = FALSE;
  }
};
  
primitive: cube | cone | cylinder | sphere | light ;
property: color | diffusion | specularity ;
tm: flag_tm matrix SEMI_COLON {
  Init_Matrix ();
};
flag_tm: TM {
  readMatrix = TRUE;
  rowMatrix = 0;
  columnMatrix = 0;
};

scale: flag_scale vector SEMI_COLON {
  Scale ();
};

flag_scale: SCALE {
  readVector = TRUE;
  elementVector = 0;
};

translate: flag_translate vector SEMI_COLON {
  Translate ();
};

flag_translate: TRANSLATE {
  readVector = TRUE;
  elementVector = 0;
};

rotate: flag_rotate vector SEMI_COLON {
  Rotate ();
};

flag_rotate: ROTATE {
  readVector = TRUE;
  elementVector = 0;
};

matrix:	LEFT_ROUND row COMA row COMA row COMA row RIGHT_ROUND {
  readMatrix = FALSE;
};

row: LEFT_ROUND float COMA float COMA float COMA float RIGHT_ROUND {
  rowMatrix++;
  columnMatrix = 0;
};

vector: LEFT_ROUND float COMA float COMA float RIGHT_ROUND {
  readVector = FALSE;
};

float: FLOAT {
  if (readSurfaceParm) { /* Reading surface parameters */
    if (Surfparm_read == 0) 
      pts_per_curve = floatvalue;
    else
      total_num_curves = floatvalue;
    SurfaceParm[Surfparm_read] = floatvalue;
    Surfparm_read++;
  }

  else if (readCurve) { /* Reading curves */
    SurfaceRead[pts_on_curve_read][curves_read][elementVector] = floatvalue;
    elementVector = (elementVector + 1) % 5;
  }

  else if (readVector)
    VectorRead[elementVector++] = floatvalue;
  else if (readMatrix)
    MatrixRead[rowMatrix][columnMatrix++] = floatvalue;
  else
    value = floatvalue;
};

cone: CONE LEFT_ROUND RIGHT_ROUND SEMI_COLON {
  Cone ();
}; 

cube: CUBE LEFT_ROUND RIGHT_ROUND SEMI_COLON {
  Cube ();
}; 

cylinder: CYLINDER LEFT_ROUND RIGHT_ROUND SEMI_COLON {
  Cylinder ();
}; 

sphere:	SPHERE LEFT_ROUND RIGHT_ROUND SEMI_COLON {
  Sphere();
}; 

light: LIGHT LEFT_ROUND RIGHT_ROUND SEMI_COLON {
  Light();
}; 

diffusion: DIFFUSION LEFT_ROUND float RIGHT_ROUND SEMI_COLON {
  Diffusion();
};

specularity: SPECULARITY LEFT_ROUND float RIGHT_ROUND SEMI_COLON {
  Specularity();
};

color: flag_color vector SEMI_COLON {
  SurfColour();
};

flag_color: COLOR {
  readVector = TRUE;
  elementVector = 0;
};

%%
yyerror(s)
     char *s;
{
  fprintf(stderr,"error: '%s' in line %d\n", s, lineno);
};
