
/* @(#)popi.h 1.6 93/06/01
 *
 *  Definitions and constants used by the popi program.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc. 
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */

#ifndef  POPI_DEFINED
#define  POPI_DEFINED

#if defined(MSDOS) && defined(M_I86)
/* Assume we are Microsoft C */
#define __MSC__ 1
#endif  /* MSC */

/* Some compilers are near enough to ANSI for our purposes.
 * In some situations the compiler has a true ANSI mode which
 * we should set if possible. But sometimes we can't because
 * we need non-standard features of the compiler (eg far pointers
 * under DOS). We can't just set __STDC__ ourselves in these cases
 * because their include files need to know the truth. So we
 * set the token STDC which means that as far as we're concerned
 * we are ANSI.
 */

#if defined(__STDC__) || defined(__TURBOC__) || defined(__MSC__)
#define STDC  1
#endif  /* __STDC__ || __TURBOC__ || __MSC__ */

/*  For all function declarations, if ANSI then use a prototype. */

#if  defined(STDC)
#define P(args)  args
#else  /* ! STDC */
#define P(args)  ()
#endif  /* STDC */

#if defined(apollo)
#include <time.h>
#endif /* apollo */

#if defined(STDC)

#include <stdlib.h>

#else  /* STDC */

/* No <stdlib.h> */

/* We can't define these as well as including <stdlib.h> because
 * some compilers (eg Turbo C) use silly nonstandard keywords (which
 * we can't #define away) as part of the type.
 */

extern void exit P((int)) ;
extern char *malloc P((unsigned int)) ;
extern char *getenv P((char *)) ;
#endif  /* STDC */

#if defined(STDC) || ! defined(BSD)
#include <string.h>
#include <sys/times.h>
#else
#include <strings.h>
#include <sys/time.h>
#endif  /* STDC || ! BSD */

#ifndef  FILE
#include  <stdio.h>
#endif  /* FILE */

/* The assumption we make here is that not all versions of <math.h>
 * define M_PI, but they all define HUGE.
 */

#ifndef      M_PI
#ifndef      HUGE
#include <math.h>
#endif    /* HUGE */

#ifndef      M_PI
#define M_PI  3.14159265358979323846
#endif    /* M_PI */
#endif    /* M_PI */

#ifndef MAXLONG
#define  BITSPERBYTE     8
#define  BITS(type)      (BITSPERBYTE * (int) sizeof(type))
#define  HIBITL          (1L << BITS(long) - 1)
#define  MAXLONG         (~HIBITL)
#endif /*MAXLONG*/

extern double pow       P((double, double)) ;
extern double sin       P((double)) ;
extern double cos       P((double)) ;
extern double atan2     P((double, double)) ;
extern double hypot     P((double, double)) ;
extern double log       P((double)) ;
extern double sqrt      P((double)) ;

#ifndef  MAXPATHLEN
#define  MAXPATHLEN     1024
#endif /* MAXPATHLEN */

#define  NELS(arr)      (sizeof (arr) / sizeof (*(arr)))

#define  DtoR(degrees)  ((degrees) * M_PI * 2.0 / 360.0)
#define  RtoD(radians)  ((radians) / (M_PI * 2.0 / 360.0))

#define  BITSINBYTE     8

/* Define RANDOM to be an expression which returns a value
 * between 0 and some large number (like maxint or maxlong).
 */

#if  defined(BSD)
#define  RANDOM    random()
extern long random P((void)) ;
#else  /* ! BSD */
#if  defined(SYSV)
#define  RANDOM    lrand48()
extern long lrand48 P((void)) ;
#else  /* ! SYSV */
#define  RANDOM    rand()
extern int rand P((void)) ;
#endif  /* SYSV */
#endif  /* BSD */

#if defined(ISTACK)                    /* Integer evaluation stack. */
typedef long pstack_t ;
#else                                  /* Floating point eval stack. */
typedef double pstack_t ;
#endif  /*ISTACK*/

typedef long parse_t ;
typedef unsigned char pixel_t ;        /* A pixel value */
typedef pixel_t *line_t ;              /* A scanline (array of pixels) */
typedef line_t *image_t ;              /* An image (array of scanlines) */
typedef int bool ;

#ifndef  FALSE
#define  FALSE    0
#define  TRUE     1
#endif  /* FALSE */

#define  CLOSE    (void) close         /* To make lint happy. */
#define  FCLOSE   (void) fclose
#define  FFLUSH   (void) fflush
#define  FPRINTF  (void) fprintf
#define  FPUTC    (void) fputc
#define  FPUTS    (void) fputs
#define  FREE     (void) free
#define  IOCTL    (void) ioctl
#define  MKTEMP   (void) mktemp
#define  PCLOSE   (void) pclose
#define  POLL     (void) poll
#define  PRINTF   (void) printf
#define  PUTC     (void) putc
#define  READ     (void) read
#define  SELECT   (void) select
#define  SIGNAL   (void) signal
#define  SPRINTF  (void) sprintf
#define  STRCAT   (void) strcat
#define  STRCPY   (void) strcpy
#define  STRNCAT  (void) strncat
#define  STRNCPY  (void) strncpy
#define  UNGETC   (void) ungetc
#define  UNLINK   (void) unlink
#define  WRITE    (void) write

#ifndef  LINT_CAST
#ifdef  lint
#define  LINT_CAST(arg)  (arg ? 0 : 0)
#else
#define  LINT_CAST(arg)  (arg)
#endif /*lint*/
#endif /*LINT_CAST*/

#ifdef   USE_BZERO
#define  CLEARMEM(arg, len)      bzero(arg, len)
#define  COPYMEM(src, dst, len)  bcopy(src, dst, len)
#else
#define  CLEARMEM(arg, len)      (void) memset(arg, '\0', len)
#define  COPYMEM(src, dst, len)  (void) memcpy(dst, src, len)
#endif /*USE_BZERO*/

#define  PUTCHAR(ch)  (void) putc(ch, stderr)

#define  BACKSPACE       8            /* For input line parsing. */
#define  DEL             127
#define  LINEFEED        13
#define  RETURN          10

#define  BITSPERPIXEL    8
#define  BOXH            40           /* Height of input dialog box. */
#define  BOXX            20           /* X position of input dialog box. */
#define  BOXY            10           /* Y position of input dialog box. */
#define  CMAPLEN         256          /* Length of the color map. */
#define  DEF_X           512          /* Image width */
#define  DEF_Y           512          /* Image height */
#define  DEF_ZSIZE       (1 << BITSPERPIXEL)
#define  MAX_ANG         1024
#define  MAXIMG          128
#define  MAX_TRIG        2048
#define  NUMEL(x)        (sizeof(x) / sizeof(*x))
#define  NUMVARS         32

#ifndef  MAXLINE
#define  MAXLINE         80           /* Length of character strings. */
#endif /*MAXLINE*/

#define  MAXOPS          2            /* No of pseudo rasterop functions. */
#define  MAXTOKENS       128

#ifndef  SIGRET
#define  SIGRET          int
#endif /*SIGRET*/

#define  THEIGHT         612          /* min. height of the popi window. */
#define  TWIDTH          512          /* min. width of the popi canvas. */

#define  ERR_NONE        0
#define  ERR_SYS         (1 << 0)     /* System error (errno set) */
#define  ERR_PARSE       (1 << 1)     /* Syntax error while parsing input */
#define  ERR_SNARK       (1 << 2)     /* Internal program error */
#define  ERR_WARN        (1 << 3)     /* Just a warning */
#define  ERR_NOREGS      (1 << 4)     /* Out of registers in Mapcoord. */
#define  ERR_NOBUF       (1 << 5)     /* No such buffer. */
#define  ERR_NOOP        (1 << 6)     /* Not a valid binop in binop. */
#define  ERR_NOCONST     (1 << 7)     /* Not a valid binop in binconst. */
#define  ERR_TOP         (1 << 8)     /* No top of tree. */
#define  ERR_DIV         (1 << 9)     /* Division by zero. */
#define  ERR_MOD         (1 << 10)    /* Modulus zero. */
#define  ERR_VAR         (1 << 11)    /* Too many variables. */
#define  ERR_NOSLOT      (1 << 12)    /* Can't find variable slot. */
#define  ERR_FPE         (1 << 13)    /* Arithmetic exception. */

#define  OP_A            0
#define  OP_ABS          1
#define  OP_AND          2
#define  OP_ASGN         3
#define  OP_AT           4
#define  OP_ATAN         5
#define  OP_CAND         6
#define  OP_CLVAL        7
#define  OP_COLON        8
#define  OP_CONDIT       9
#define  OP_COR          10
#define  OP_COS          11
#define  OP_CRVAL        12
#define  OP_DIV          13
#define  OP_EQ           14
#define  OP_GE           15
#define  OP_GT           16
#define  OP_HYPOT        17
#define  OP_LE           18
#define  OP_LOG          19
#define  OP_LSHIFT       20
#define  OP_LT           21
#define  OP_MINUS        22
#define  OP_MOD          23
#define  OP_MUL          24
#define  OP_NE           25
#define  OP_NOT          26
#define  OP_OR           27
#define  OP_PLUS         28
#define  OP_PLVAL        29
#define  OP_POW          30
#define  OP_PRVAL        31
#define  OP_R            32
#define  OP_RAND         33
#define  OP_RSHIFT       34
#define  OP_SIN          35
#define  OP_SQRT         36
#define  OP_UMIN         37
#define  OP_VALF         38
#define  OP_VALUE        39
#define  OP_X            40
#define  OP_XOR          41
#define  OP_Y            42

#ifdef  NDEBUG
#define  DEBUG(stuff)
#ifndef assert
#define  _assert(ex)
#define  assert(ex)
#endif  /* assert */
#else  /* ! NDEBUG */
#define  DEBUG(stuff)  if (Debug) FPRINTF stuff
#ifndef assert
#define  _assert(ex)  {                                                 \
           if (!(ex)) {                                                 \
             DEBUG((Debug, "Assertion failed: file \"%s\", line %d\n",  \
             __FILE__, __LINE__)) ;                                     \
             exit(1) ;                                                  \
           }                                                            \
         }
#define  assert(ex)   _assert(ex)
#endif  /* assert */
#endif  /* ! NDEBUG */

enum cur_type { BUSY_CUR, NORMAL_CUR } ; /* Cursor types. */

enum disp_type { IS_COLOR, IS_GRAY, IS_MONO } ;  /* Type to display in. */

enum font_type { BFONT, NFONT } ;        /* Fonts used by popi. */

enum op_type  { GCLR, GSET } ;           /* Pseudo rasterop functions. */

enum rng_type { CUT, WRAP, MINMAX } ;    /* How to handle range errors */

struct SRC
{
  pixel_t **pix ;          /* *pix[color] */
  int     width ;          /* Image width. */
  int     height ;         /* Image height. */
  int     Xalloc ;         /* Length of a scanline in pixels. */
  int     ncolors ;        /* Number of colors (1/gray or 3/rgb). */
  char    *str ;           /* Image name. */
} ;

union IntFloat        /* Used for putting a float into an array of long. */
{
  long  intgr ;
  float flt ;
} ;


#if  SEQPAR
#ifndef  sequent
#include "Sorry, this will only work on a sequent"
#endif  /* sequent */
#define malloc  shmalloc
#endif  /* SEQPAR */

/* External declarations */

/* main.c */
extern char *Emalloc       P((unsigned int)) ;
extern int getImageNo      P((char *)) ;
extern void error          P((int)) ;
extern void PrStrs         P((char **)) ;
extern void run_error      P((int)) ;

/* io.c */
extern pixel_t **ImgAlloc  P((int, int, int)) ;
extern void ImgFree        P((struct SRC *)) ;
extern void Efclose        P((FILE *)) ;
extern FILE *EfopenR       P((char *)) ;
extern FILE *EfopenW       P((char *)) ;
extern void adjust_image   P((struct SRC *, pixel_t **, int, int)) ;
extern void getpix         P((char *, char *, int)) ;
extern void putpix         P((struct SRC *, char *)) ;
extern void prntimg        P((char *, struct SRC *)) ;

/* special.c */
extern void OpenLog          P((FILE **)) ;

/* colspec.c */
extern void imageOK           P((int)) ;

/* run.c */
extern void SwapOldNew       P((void)) ;
extern void run              P((void)) ;
extern void drawimg          P((struct SRC *)) ;
extern pixel_t *ntsc_luma    P((pixel_t **, int, int)) ;

/* polar.c */
extern void MakePolar        P((void)) ;

/* dither.c */
extern struct SRC *dither24to8   P((struct SRC *)) ;
extern void halftone             P((unsigned char *, int, int)) ;
extern void init_dither          P((void)) ;

/* driver routines */
void disp_init        P((int, char**)) ;
void disp_finish      P((void)) ;
void disp_imgstart    P((int, int, int, int)) ;
void disp_imgend      P((void)) ;
void disp_putline     P((pixel_t **, int, int, int)) ;
void disp_error       P((int, int)) ;
void disp_percentdone P((int)) ;
void disp_resize      P((int, int)) ;
void disp_colormap    P((int, unsigned char *,
                              unsigned char *, unsigned char *)) ;
int disp_prompt       P((void)) ;
int disp_getchar      P((void)) ;

/* External variable declarations */

extern char SaveChar ;         /* One level of character pushback on stdin. */
extern char ErrBuf[] ;
extern char *ProgName ;        /* Name of this program. */
extern char lastfname[] ;      /* Last filename parsed. */
extern char lastimage[] ;      /* Last image name parsed. */
extern char *LogFile ;         /* Name of file for logging commands */

extern FILE *Debug ;           /* Debugging stream */
extern FILE *LogStr ;          /* Command logging stream */
extern FILE *InputStream ;     /* Current input stream. */

extern enum disp_type dtype ;  /* Type to display in (color/gray/mono). */
extern enum rng_type rng_policy ;
			       /* How to handle range under-/overflow. */

extern long parsed[] ;

extern int careful ;
extern int CharPos ;           /* Position in input line. */
extern int HaveToken ;         /* Set when one (or more) tokens parsed. */
extern int OldPos ;            /* Previous character position on input line */
extern int TokPos ;            /* Position of beginning of current token */
extern int RangeCheck ;
extern int treedump ;
extern int Xsize ;
extern int Ysize ;
extern int Zsize ;
extern pixel_t *ntsc ;         /* NTSC luma line. */
extern pixel_t Zmax ;

#if defined(ISTACK)
extern short *avals ;
extern short *rvals ;
#else
extern float *avals ;
extern float *rvals ;
#endif /*ISTACK*/

extern int noerr ;             /* Indicates if an error has occured. */
extern int nimages ;
extern int prs ;
extern int Verbose ;
extern int Truncate ;
extern int colors ;
extern int col_used ;	       /* No. of colors in current computation. */
extern int rev_video ;         /* Set if monochrome reverse video. */
extern int signed_io ;
extern int oldfmt ;
extern int scr_depth ;         /* Screen depth (where appropriate). */

extern int BOXW ;
extern int TXsize ;
extern int TYsize ;

extern struct SRC Images[MAXIMG] ;
extern struct SRC *CurOld ;
extern struct SRC *CurNew ;

extern int disp_active ;       /* Display results after each operation. */

#if       SEQPAR
extern int ncpus ;             /* No. cpus to use in parallel */
#endif /* SEQPAR */

#endif  /* POPI_DEFINED */
