/*LINTLIBRARY*/

/*  @(#)atariterm.c 1.3 92/04/16
 *
 *  Popi graphics driver for atari TERM windows.
 *  Written by Stephen Frede, Softway Pty Ltd.
 *
 *  Popi was originally written by Gerard J. Holzmann - AT&T Bell Labs.
 *  This version is based on the code in his Prentice Hall book,
 *  "Beyond Photography - the digital darkroom," ISBN 0-13-074410-7,
 *  which is copyright (c) 1988 by Bell Telephone Laboratories, Inc. 
 *
 *  Permission is given to distribute these extensions, as long as these
 *  introductory messages are not removed, and no monies are exchanged.
 *
 *  No responsibility is taken for any errors or inaccuracies inherent
 *  either to the comments or the code of this program, but if reported
 *  (see README file) then an attempt will be made to fix them.
 */


#include <stdio.h>
#include <sys/types.h>
#include "popi.h"

thresh[BITSPERPIXEL][BITSPERPIXEL] =
{        /* Array containing threshold values. */
    {   0, 128,  32, 160,   8, 136,  40, 168, },
    { 192,  64, 224,  96, 200,  72, 232, 104, },
    {  48, 176,  16, 144,  56, 184,  24, 152, },
    { 240, 112, 208,  80, 248, 120, 216,  88, },
    {  12, 140,  44, 172,   4, 132,  36, 164, },
    { 204,  76, 236, 108, 196,  68, 228, 100, },
    {  60, 188,  28, 156,  52, 180,  20, 148, },
    { 252, 124, 220,  92, 244, 116, 212,  84, },
};

int	ImgInProgress = 0;

/*  These are the exportable routines used by the popi program.
 *
 *  disp_init(argc, argv)    - called from main at the start.
 *  disp_finish()            - called from main prior to exit.
 *  disp_imgstart(w,h,c,l)   - called prior to drawing an image.
 *  disp_imgend()            - called after drawing an image.
 *  disp_putline(l,y,w,c)    - to draw an image scanline triple.
 *  disp_getchar()           - to get the next character typed.
 *  disp_prompt()            - display popi prompt and clear input buffer.
 *  disp_error(errtype)      - display error message.
 *  disp_percentdone(n)      - display percentage value of conversion.
 *  disp_resize(w,h)         - resize popi image window (width, height).
 *  disp_colormap(n,r,g,b)   - load new colormap.
 */

/*ARGSUSED*/
void
disp_init(argc,argv)
int argc;
char *argv[];
{
}

void
disp_finish()
{
}

void
disp_imgstart(width, height, ncolors, len)
int width, height, ncolors, len ;
{
    ImgInProgress = 1;

    putchar('\033');
    putchar('[');
    putchar('?');
    putchar('3');
    putchar('2');
    putchar('h');
    putchar('\033');
    putchar('[');
    putchar('2');
    putchar('J');
    putchar('\033');
    putchar('[');
    putchar(';');
    putchar('H');
}

void
disp_imgend()
{
    ImgInProgress = 0;

    putchar('\033');
    putchar('[');
    putchar('?');
    putchar('3');
    putchar('2');
    putchar('l');
}

void
disp_putline(lines, y, width, ncolors)    /* Output scanline y. */
pixel_t **lines;
int y, width, ncolors;
{
    int x;
    short wd;
    int bit;
    pixel_t *line;

    line = ntsc_luma(lines, y, width);
    for (x = 0; x < width;)
    {
	wd = 0;
	for (bit = 15; bit >= 0; --bit, ++x)
	    if (*line++ < thresh[y % BITSPERPIXEL][x % BITSPERPIXEL])
		wd |= 1 << bit;
	putchar('0' + ((wd >> 10) & 0x3f));
	putchar('0' + ((wd >> 5) & 0x1f));
	putchar('0' + (wd & 0x1f));
    }
    putchar('\n');
}


disp_getchar()          /* Get next user typed character. */
{
    return(getchar());
}


disp_prompt()         /* Display popi prompt and clear input line. */
{
    PRINTF("-> ");
    return 3;
}


void
disp_error(errtype, pos)         /* Display error message. */
int	errtype,
	pos;
{
    extern int  errno;
    extern char *sys_errlist[];

    if (errtype & ERR_PARSE)
    {
        int     i;
 
        for (i=1; i < pos; ++i)
            PUTC('-', stderr);
        PUTC('^', stderr);
        PUTC('\n', stderr);
    }
 
    FPRINTF(stderr, "%s\n", ErrBuf);
    /* we assume errno hasn't been reset by the preceding output */
    if (errtype & ERR_SYS)
        FPRINTF(stderr, "\t(%s)\n", sys_errlist[errno]);
}

void
disp_percentdone(percent)
int	percent;
{
    static int	lastpercent = 100;

    if (!Verbose || ImgInProgress)
	return;

    if (percent == 100)
    {
	printf("\r    \r");
	return;
    }

    if
    (
	percent != lastpercent
	/* && percent % 5 == 0 */
    )
    {
	printf("\r%2d%% ", percent);
	fflush(stdout);
	lastpercent = percent;
    }
}


void
disp_resize(width, height)       /* Resize popi image window. */
int width, height ;
{
}


void
disp_colormap(n, red, green, blue)      /* Load new colormap. */
int n ;
unsigned char *red, *green, *blue ;
{
}
