#include <stdio.h>
#include <stdlib.h>

#define FALSE 0
#define TRUE (!FALSE)

enum { Boundary, Inside, Outside, Unset };
enum { VX = 0, VY };

typedef float pos2d[2];
typedef char boolean;

int
location(pos2d pt1, pos2d pt2, pos2d testpt)
{
  float A,B,C,result;

  A = pt2[VY] - pt1[VY];
  B = pt1[VX] - pt2[VX];
  C = -A*pt1[VX] - B*pt1[VY];

  result = A*testpt[VX] + B*testpt[VY] + C;

  if (result < 0.0)
    return (Inside);
  else if (result > 0.0)
    return (Outside);
  else
    return (Boundary);
}

void
make_perturbed_vec(pos2d pt1, pos2d pt2, pos2d vec)
{
  vec[VX] = pt2[VX] - pt1[VX];
  if (vec[VX] == 0.0)
    vec[VX] = 1.0;
}

boolean
poly_is_convex(pos2d points[], int numpoints)
{
  int i,lastlocation,thislocation, checklocation = Unset;
  int num_dir_flips = 0, lastvec = 0, thisvec = 1;
  int prevpt = numpoints-1, nextpt = 1, convex = TRUE;
  pos2d edgevecs[2];
  boolean dir_flip;

  /* if 3 points or less poly is convex or convexity/concavity is ambiguous */
  if (numpoints <= 3)
    return (convex);

  make_perturbed_vec(points[prevpt],points[0],edgevecs[lastvec]);

  for (i=0; i<numpoints; i++)
  {/* we simultaneously test for simplicity and convexity */
    thislocation = location(points[prevpt],points[i],points[nextpt]);

    if ((checklocation == Unset) && (thislocation != Boundary))
      checklocation = thislocation;

    make_perturbed_vec(points[i],points[nextpt],edgevecs[thisvec]);
    if (thislocation != Boundary)
    {
      convex = convex && (thislocation == checklocation);
      if (edgevecs[thisvec][VX]*edgevecs[lastvec][VX] < 0.0)
	if (thislocation != checklocation)
	  num_dir_flips--; /* should really just return FALSE here! */
	else
	  num_dir_flips++;
    }

    prevpt = i;
    if (++nextpt == numpoints)
      nextpt = 0;

    lastvec = thisvec;
    thisvec = 1 - lastvec;
  }

  /* if abs(num_dir_flips) == 2 the winding number is 1 */
  /* if winding is not 1 the poly is concave or ambiguous */
  if (abs(num_dir_flips) != 2)
    convex = FALSE;
  
  return (convex);
}


int
main()
 {
  pos2d points[64];
  int numpoints,i;
 
  for(i=0;;i++)
   {
    if (2 != fscanf(stdin," %f %f",&points[i][0],&points[i][1]))
     { numpoints = i; break; }
   }

  if (poly_is_convex(points,numpoints) )
   { fprintf(stderr,"CONVEX\n"); exit(0); }
  else 
   { fprintf(stderr,"NOT CONVEX\n"); exit(-1); }
 }
