/*
$Header: list.h,v 1.7 93/08/30 11:01:33 hmallat Exp $
*/

#ifndef LIST

#include "pixel.h"
#include <X11/Intrinsic.h>

struct view {struct picture *pic_p;      /* pointer to picture struct */
	     color color1, color2;       /* primary and secondary drawing
					    colors */
	     int scale;                  /* scale factor, 1=normal */
	     int x1, y1, x2, y2;         /* (x1, y1) are the left upperhand
					    coordinates of the view in picture.
					    (x2, y2) are the right lowerhand
					    coordinates */
	     Widget main;                /* The root of the view window */
	     Widget draw_area;           /* the drawing area widget of the
					    view window */
	     Widget coord_ind;           /* the coordinate indicator widget */
	     Widget prim_ind;            /* the primary colour indicator */
	     Widget second_ind;          /* the secondary colour indicator */
	     Widget h_scroll;            /* horizontal scroll widget */
	     Widget v_scroll;            /* vertical scroll widget */
	     Widget zoom;                /* infobar text */
	     GC gc;
	     Window busy_view;       
	     struct view *next;          /* pointer to next view struct
					    NULL declares end of list */
	   };

struct view *new_picture(int w, int h, char *name);

void abandon_picture();
void abandon_all();
void touch(struct picture *pic_p);
void untouch(struct picture *pic_p);
int is_touched(struct view *v_p);
struct view *add_view(struct picture *pic_p,
		      int x1, int y1, int x2, int y2, int scale);
void del_view(struct view *v_p);
void del_views(struct picture *pic_p);
void del_all();

#define LIST
#endif
