
/* ****************************************************************** */
/* Function : SortList.c
 * 
 * Author   : J.Paul Schmidt.
 * 
 * Cree le  : 88/04/12 Version  : 1.2
 * 
 * Modifications : 90/01/18 Author   : Reason   :
 * 
 * Implemented functionality : Sort a list.
 * 
 * Input parameters : List identifier. (Ptr to 1st element). Address of the
 * function used to compar 2 elements. Access function on which the sorting is
 * based. function(a,b)  should return :  1 if a > b 0 if a = b -1 if a < b
 * 
 * Output parameter : None. */
/* ****************************************************************** */

#include "ListeP.h"

long SortList (
#if NeedFunctionPrototypes
  Liste s_idlist,		/* list to process indentifier */
  long (*function) ()		/* function used to compar the elements */
)
#else
s_idlist, function)
  Liste s_idlist;		/* list to process indentifier */
  long (*function) ();		/* function used to compar the elements */
#endif

{
  ty_list *p_firstelem;		/* Pointer to the list to process */
  ty_node *p_curent;
  int *table;			/* table where to put the list to sort */
  int i;			/* Table index */

#ifdef debug
  (void) fprintf (stderr, " Function : SortList \n");
#endif

  /* Parameter transformation */
  p_firstelem = (ty_list *) s_idlist;

  Lst_TestPar (p_firstelem, "NULL POINTER AS PARAMETER \n", ERRNU);

  if (p_firstelem->num == 0) {	/* empty list */

#ifdef debug
    (void) fprintf (stderr, " End of : SortList \n");
#endif

    return (PASERR);
  }

  /* Creation of the table and fill it */
  table = (int *) calloc (p_firstelem->num, sizeof (long));
  i = 0;
  p_curent = p_firstelem->p_first;
  do {
    table[i++] = p_curent->s_elem;
    p_curent = p_curent->p_suiv;
  } while (p_curent != NULL);


  qsort (table, p_firstelem->num, sizeof (int), function);

  /* Uptadte the list */
  p_curent = p_firstelem->p_first;
  p_curent->s_elem = table[0];

  /* case of the next elements */
  for (i = 1; i < p_firstelem->num; i++) {
    p_curent = p_curent->p_suiv;/* Next element */
    p_curent->s_elem = table[i];
  }				/* End of the for (i=1 ; i==p_firstelem->num ;
				 * i++) */

#ifdef debug
  (void) fprintf (stderr, " End of : SortList \n");
#endif

  return (PASERR);

}				/* End of SortList */
