

/* ****************************************************************** */
/* Function : MapList.c
 * 
 * Author   : J.Paul Schmidt.
 * 
 * Cree le  : 88/04/12 Version  : 1.2
 * 
 * Modifications : 90/01/18 Author   : Reason   :
 * 
 * Implemented functionality : Apply a function to every elements of the list.
 * 
 * Input parameters : List identifier. (Ptr to 1st element). Function address.
 * 
 * Output parameter : None. */
/* ****************************************************************** */

#include "ListeP.h"

long MapList (
#if NeedFunctionPrototypes
  Liste s_idlist,		/* list to process indentifier */
  void (*function) ()		/* Called function */
)
#else
s_idlist, function)
  Liste s_idlist ;                 /* list to process indentifier */
  void (*function) () ;           /* Called function */
#endif

{
  ty_list *p_firstelem;		/* Pointer to the list to process */
  ty_node *p_curent;

#ifdef debug
  (void) fprintf (stderr, " Function : MapList \n");
#endif

  /* Parameter transformation */
  p_firstelem = (ty_list *) s_idlist;

  Lst_TestPar (p_firstelem, "NULL POINTER AS PARAMETER \n", ERRNU);

  /* parcours de la list */
  p_curent = p_firstelem->p_first;
  while (p_curent != NULL) {
    /* Function call */
    (*function) (p_curent->s_elem);
    p_curent = p_curent->p_suiv;
  }				/* End of the while (p_curent != NULL)  */

#ifdef debug
  (void) fprintf (stderr, " End of : MapList \n");
#endif

  return (PASERR);

}				/* End of MapList */
