

/* ****************************************************************** */
/* Function : ElmNumList.c
 * 
 * Author   : J.Paul Schmidt.
 * 
 * Cree le  : 88/04/12 Version  : 1.2
 * 
 * Modifications : 90/01/18 Author   : Reason   :
 * 
 * Implemented functionality : Find the  le Jth element of a list.
 * 
 * Input parameters : List identifier. (Ptr to 1st element). # of the element
 * looked for.
 * 
 * Output parameter : Jth element of the list or error. */
/* ****************************************************************** */

#include "ListeP.h"

long ElmNumList (
#if NeedFunctionPrototypes
  Liste s_idlist,		/* list to process indentifier */
  int j				/* looked for element */
)
#else
s_idlist, j)
  Liste s_idlist ;		/* list to process indentifier */
  int j ;			/* looked for element */
#endif

{
  ty_list *p_firstelem;		/* Pointer to the list to process */
  ty_node *p_curent;
  int cpteur;


#ifdef debug
  (void) fprintf (stderr, " Function : ElmNumList \n");
#endif

  /* Parameter transformation */
  p_firstelem = (ty_list *) s_idlist;

  Lst_TestPar (p_firstelem, "NULL POINTER AS PARAMETER \n", ERRNU);
  Lst_TestPar (p_firstelem->p_first, "EMPTY LIST \n", ERRVI);

  if (p_firstelem->num < j || j == 0) {	/* Unexisting element */

#ifdef debug
    (void) fprintf (stderr, " ERREUR, Innexisting element \n ");
    (void) fprintf (stderr, "         J was : %d \n", j);
    (void) fprintf (stderr, " And there is  %d elements only in the list \n",
		    p_firstelem->num);
    (void) fprintf (stderr, " End of : ElmNumList \n");
#endif

    return (ERRVI);
  };

  if (p_firstelem->num == j) {	/* last element */

#ifdef debug
    (void) fprintf (stderr, " End of : ElmNumList \n");
#endif

    return (p_firstelem->p_last->s_elem);
  };

  p_curent = p_firstelem->p_first;
  for (cpteur = 1; cpteur < j; cpteur++)
    p_curent = p_curent->p_suiv;

#ifdef debug
  (void) fprintf (stderr, " End of : ElmNumList \n");
#endif

  return (p_curent->s_elem);

}				/* End of ElmNumList */
