/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

Name : SkipLines
Type : int
Written on   : 14-Nov-90     By : A. Etemadi
Modified on  :               By : 
Directory    : ~atae/ORT/ORT/LPEG/src/MiscRoutines

==============================================================================

Input parameters    : 
 p_InFile 		-- Pointer to position in file
 LineLength		-- Maximum length of 1 line of header
 LinesToSkip		-- Number of lines to skip
 PrintFlag		-- 0 means print skipped lines 1 means do not print

Output parameters   : 
 None

Output result       : 
  0 = successful, 
 -1 = EOF 

Functions called:
 SkipLine

Calling procedure:

 int LineLength;
 int LinesToSkip;
 int PrintFlag;

 FILE *p_InFile;

 SkipLines(&p_InFile,LineLength,LinesToSkip,PrintFlag);

Functionality: 

This function skips LinesToSkip lines of data stored in a file 
from the position pointed to currently by the file pointer p_InFile.

----------------------------------------------------------------------------*/

#include <stdio.h>     /* Standard C I/O library */
#include <math.h>      /* Standard C mathematics library */
#include <errno.h>     /* Standard C error handling routines */
/* #include <strings.h> */   /* Standard C string handling routines */
#include <ctype.h>     /* Standard C type identification routines */

int SkipLines (p_InFile,
		  LineLength,
		  LinesToSkip,
		  PrintFlag)

 int LineLength;
 int LinesToSkip;
 int PrintFlag;

 FILE *(*p_InFile);

{
	int i;                       /* Loop index */
	char LineBuffer[100]; /* Just a buffer to store the characters */

#ifdef debug
          fprintf(stderr," Start of function SkipLines \n");
#endif

/*
 Skip LinesToSkip lines of Lines

*/
   for (i=0;i<LinesToSkip;i++) {

            if  ( (fgets(LineBuffer,LineLength,*p_InFile)) != NULL) {
                   if (PrintFlag == 0) 
                       fprintf(stderr,"-> %s",LineBuffer);
	     }
             else {
                   return(-1);
            }
   }

                   return(0);

#ifdef debug
          fprintf(stderr," End of function SkipLines \n");
#endif

}

