/*

                              DISCLAIMER
                              ==========

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.   

    If the software is modified by someone else and passed on, we, the authors
    want its recipients to know that what they have is not the original, so
    that any problems introduced by others will not reflect on the original
    authors' reputations.
*/                                            

/*
** Test program for transforms module.
** W.T. Hewitt.
*/

#include "nurbh.h"

#define LINE printf("*************************************\n")

PR_nurb c1, c2, c3, c4;
PR_nurb s1, s2, s3, s4;

Pint ee,ii,nsteps;

Pfloat dt,t1,t2;
Pmatrix3 xx;
PR_dir  tnew= {0};

void putpoint3(C(FILE *)fp, C(Ppoint3)xx)
PreANSI(FILE *fp)
PreANSI(Ppoint3 xx)
{
fprintf(fp,"%12.4g%12.4g%12.4g",xx.x,xx.y,xx.z);
}

main()
{
  printf("Testing NURBS\n");

  nrb_clear(&c1);
  nrb_clear(&c2);
  nrb_clear(&c3);
  nrb_clear(&c4);

  nrb_clear(&s1);
  nrb_clear(&s2);
  nrb_clear(&s3);
  nrb_clear(&s4);

  LINE;
  printf("Unit circle\n");
  nrb_circle(&c1);
  nrb_dump(stdout,&c1);

  LINE;
  printf("Oslo refined circle\n");
  nrb_copy(&c1,&c2);
  c2.pf_u.pf_nt = 20;
  c2.pf_u.pf_n = c2.pf_u.pf_nt -c2.pf_u.pf_k;

  nrb_makeknots(0.0,1.0,&c2.pf_u);
  nrb_unionknots(&c1.pf_u,&c2.pf_u,&c2.pf_u);
  nrb_osloc(&c1,&c2);
  nrb_transpose(&c2);
  nrb_dump(stdout,&c2);

  LINE;
  printf("Boehm refined circle\n");
  nrb_copy(&c1,&c3);
  c3.pf_u.pf_nt = 20;
  c3.pf_u.pf_n = c3.pf_u.pf_nt -c3.pf_u.pf_k;

  nrb_makeknots(0.0,1.0,&c3.pf_u);
  nrb_dumpknots(stdout,"c3.pf_u",&c3.pf_u);
  nrb_unionknots(&c1.pf_u,&c3.pf_u,&c3.pf_u);
  nrb_dumpknots(stdout,"Unioned knots",&c3.pf_u);

  nrb_differenceknots(&c1.pf_u,&c3.pf_u,&tnew);
  nrb_dumpknots(stdout,"tnew",&tnew);
  nrb_boehmc(&c1,&tnew,&c3);
  nrb_transpose(&c3);
  nrb_dump(stdout,&c3);

  nrb_stats(stdout);
  nrb_dumplists(stdout);

  printf("End of NURBs test.\n");
}

/* End. */
