/*

                              DISCLAIMER
                              ==========

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.   

    If the software is modified by someone else and passed on, we, the authors
    want its recipients to know that what they have is not the original, so
    that any problems introduced by others will not reflect on the original
    authors' reputations.
*/                                            

/*
** Test program for transforms module.
** W.T. Hewitt.
*/

#include "nurbh.h"

#define LINE printf("*************************************\n")

PR_nurb c1, c2, c3, c4;
PR_nurb s1, s2, s3, s4;
Pvector3 v1;

Pint ee;

Pmatrix3 xx;

main()
{
  printf("Testing NURBS\n");

  nrb_clear(&c1);
  nrb_clear(&c2);
  nrb_clear(&c3);
  nrb_clear(&c4);

  nrb_clear(&s1);
  nrb_clear(&s2);
  nrb_clear(&s3);
  nrb_clear(&s4);

  LINE;
  printf("Circle\n");
  nrb_circle(&c1);
   v1 = ptk_vector3(100.0,100.0,100.0);
  ptk_scale3(&v1 ,PREPLACE,xx);
  nrb_xform(&c1,xx);
  nrb_dump(stdout,&c1);

  LINE;
  printf("Elevated circle\n");
  nrb_elevate(FALSE,&c1,&c2);
  nrb_dump(stdout,&c2);

  LINE;
  printf("Triangle\n");
  nrb_triangle(&s1) ;
  nrb_dump(stdout,&s1);

  LINE;
  printf("Circle\n");
  nrb_circle(&s2) ;
  v1 = ptk_vector3(0.0,0.0,2.0);
  ptk_shift3(&v1,PREPLACE,xx);
  nrb_xform(&s2,xx);
  nrb_dump(stdout,&s2);

  LINE;
  printf("Ruled Surface\n");
  nrb_ruled(&s1,&s2,&s3,&ee);
  nrb_dump(stdout,&s3);


  nrb_stats(stdout);
  nrb_dumplists(stdout);

  printf("End of NURBs test.\n");
  return 0;
}

/* End. */
