/* stringutils.c generated from stringutils.psw
   by unix pswrap V1.009  Wed Apr 19 17:50:24 PDT 1989
 */

#include "dpsfriends.h"
#include <string.h>

#line 1 "stringutils.psw"
/*
 * stringutils.psw - a collection of display postscript string utilities.
 *                   Each function is a postscript program wraped with a
 *                   defineps/endps pair.  This allows the defined functions
 *                   to be converted to C code via the "pswrap" command.
 *
 * Written by:  Wesley C. Barris
 *              AHPCRC
 *              Minnesota Supercomputer Center, Inc.
 * Date:        May 12, 1992
 * Copyright @ 1992, Minnesota Supercomputer Center, Inc.
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 *
 */
#line 29 "stringutils.c"
void PSWSelectFont(ctxt, font, scale)
DPSContext ctxt; char *font; float scale; 
{
  typedef struct {
    unsigned char tokenType;
    unsigned char sizeFlag;
    unsigned short topLevelCount;
    unsigned long nBytes;

    DPSBinObjGeneric obj0;
    DPSBinObjGeneric obj1;
    DPSBinObjReal obj2;
    DPSBinObjGeneric obj3;
    DPSBinObjGeneric obj4;
    } _dpsQ;
  static _dpsQ _dpsF = {
    DPS_DEF_TOKENTYPE, 0, 5, 48,
    {DPS_LITERAL|DPS_STRING, 0, 0, 40},	/* param font */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 67},	/* findfont */
    {DPS_LITERAL|DPS_REAL, 0, 0, 0},	/* param: scale */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 140},	/* scalefont */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 149},	/* setfont */
    }; /* _dpsQ */
  register DPSBinObjRec *_dpsP = (DPSBinObjRec *)&_dpsF.obj0;
  register int _dps_offset = 40;

  _dpsP[0].length = strlen(font);
  _dpsP[2].val.realVal = scale;
  _dpsP[0].val.stringVal = _dps_offset;
  _dps_offset += _dpsP[0].length;

  _dpsF.nBytes = _dps_offset+8;
  DPSBinObjSeqWrite(ctxt,(char *) &_dpsF,48);
  DPSWriteStringChars(ctxt, (char *)font, _dpsP[0].length);
}
#line 28 "stringutils.psw"

#line 67 "stringutils.c"
void PSWSetRotation(ctxt, angle)
DPSContext ctxt; int angle; 
{
  typedef struct {
    unsigned char tokenType;
    unsigned char topLevelCount;
    unsigned short nBytes;

    DPSBinObjGeneric obj0;
    DPSBinObjGeneric obj1;
    } _dpsQ;
  static _dpsQ _dpsF = {
    DPS_DEF_TOKENTYPE, 2, 20,
    {DPS_LITERAL|DPS_INT, 0, 0, 0},	/* param: angle */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 136},	/* rotate */
    }; /* _dpsQ */
  register DPSBinObjRec *_dpsP = (DPSBinObjRec *)&_dpsF.obj0;

  _dpsP[0].val.integerVal = angle;
  DPSBinObjSeqWrite(ctxt,(char *) &_dpsF,20);
}
#line 37 "stringutils.psw"

#line 91 "stringutils.c"
void PSWDisplayText(ctxt, X, Y, text)
DPSContext ctxt; int X, Y; char *text; 
{
  typedef struct {
    unsigned char tokenType;
    unsigned char sizeFlag;
    unsigned short topLevelCount;
    unsigned long nBytes;

    DPSBinObjGeneric obj0;
    DPSBinObjGeneric obj1;
    DPSBinObjGeneric obj2;
    DPSBinObjGeneric obj3;
    DPSBinObjGeneric obj4;
    } _dpsQ;
  static _dpsQ _dpsF = {
    DPS_DEF_TOKENTYPE, 0, 5, 48,
    {DPS_LITERAL|DPS_INT, 0, 0, 0},	/* param: X */
    {DPS_LITERAL|DPS_INT, 0, 0, 0},	/* param: Y */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 107},	/* moveto */
    {DPS_LITERAL|DPS_STRING, 0, 0, 40},	/* param text */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 160},	/* show */
    }; /* _dpsQ */
  register DPSBinObjRec *_dpsP = (DPSBinObjRec *)&_dpsF.obj0;
  register int _dps_offset = 40;

  _dpsP[0].val.integerVal = X;
  _dpsP[1].val.integerVal = Y;
  _dpsP[3].length = strlen(text);
  _dpsP[3].val.stringVal = _dps_offset;
  _dps_offset += _dpsP[3].length;

  _dpsF.nBytes = _dps_offset+8;
  DPSBinObjSeqWrite(ctxt,(char *) &_dpsF,48);
  DPSWriteStringChars(ctxt, (char *)text, _dpsP[3].length);
}
#line 54 "stringutils.psw"

#line 130 "stringutils.c"
void PSWDisplayTextOutline(ctxt, X, Y, text)
DPSContext ctxt; int X, Y; char *text; 
{
  typedef struct {
    unsigned char tokenType;
    unsigned char sizeFlag;
    unsigned short topLevelCount;
    unsigned long nBytes;

    DPSBinObjGeneric obj0;
    DPSBinObjGeneric obj1;
    DPSBinObjGeneric obj2;
    DPSBinObjGeneric obj3;
    DPSBinObjGeneric obj4;
    DPSBinObjGeneric obj5;
    DPSBinObjGeneric obj6;
    DPSBinObjGeneric obj7;
    DPSBinObjGeneric obj8;
    DPSBinObjGeneric obj9;
    } _dpsQ;
  static _dpsQ _dpsF = {
    DPS_DEF_TOKENTYPE, 0, 10, 88,
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 111},	/* newpath */
    {DPS_LITERAL|DPS_INT, 0, 0, 0},	/* param: X */
    {DPS_LITERAL|DPS_INT, 0, 0, 0},	/* param: Y */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 107},	/* moveto */
    {DPS_LITERAL|DPS_STRING, 0, 0, 80},	/* param text */
    {DPS_LITERAL|DPS_BOOL, 0, 0, 0},
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 17},	/* charpath */
    {DPS_LITERAL|DPS_INT, 0, 0, 2},
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 155},	/* setlinewidth */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 167},	/* stroke */
    }; /* _dpsQ */
  register DPSBinObjRec *_dpsP = (DPSBinObjRec *)&_dpsF.obj0;
  register int _dps_offset = 80;

  _dpsP[1].val.integerVal = X;
  _dpsP[2].val.integerVal = Y;
  _dpsP[4].length = strlen(text);
  _dpsP[4].val.stringVal = _dps_offset;
  _dps_offset += _dpsP[4].length;

  _dpsF.nBytes = _dps_offset+8;
  DPSBinObjSeqWrite(ctxt,(char *) &_dpsF,88);
  DPSWriteStringChars(ctxt, (char *)text, _dpsP[4].length);
}
#line 73 "stringutils.psw"

#line 179 "stringutils.c"
void PSWDisplayChar(ctxt, X, Y, c)
DPSContext ctxt; int X, Y; int c; 
{
  typedef struct {
    unsigned char tokenType;
    unsigned char topLevelCount;
    unsigned short nBytes;

    DPSBinObjGeneric obj0;
    DPSBinObjGeneric obj1;
    DPSBinObjGeneric obj2;
    DPSBinObjGeneric obj3;
    DPSBinObjGeneric obj4;
    DPSBinObjGeneric obj5;
    DPSBinObjGeneric obj6;
    DPSBinObjGeneric obj7;
    DPSBinObjGeneric obj8;
    char obj9[1];
    } _dpsQ;
  static _dpsQ _dpsF = {
    DPS_DEF_TOKENTYPE, 9, 77,
    {DPS_LITERAL|DPS_INT, 0, 0, 0},	/* param: X */
    {DPS_LITERAL|DPS_INT, 0, 0, 0},	/* param: Y */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 107},	/* moveto */
    {DPS_LITERAL|DPS_STRING, 0, 1, 72},
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 56},	/* dup */
    {DPS_LITERAL|DPS_INT, 0, 0, 0},
    {DPS_LITERAL|DPS_INT, 0, 0, 0},	/* param: c */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 120},	/* put */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 160},	/* show */
    {'x'},
    }; /* _dpsQ */
  register DPSBinObjRec *_dpsP = (DPSBinObjRec *)&_dpsF.obj0;

  _dpsP[0].val.integerVal = X;
  _dpsP[1].val.integerVal = Y;
  _dpsP[6].val.integerVal = c;
  DPSBinObjSeqWrite(ctxt,(char *) &_dpsF,77);
}
#line 90 "stringutils.psw"

#line 221 "stringutils.c"
void PSWStringWidth(ctxt, text, width)
DPSContext ctxt; char *text; float *width; 
{
  typedef struct {
    unsigned char tokenType;
    unsigned char sizeFlag;
    unsigned short topLevelCount;
    unsigned long nBytes;

    DPSBinObjGeneric obj0;
    DPSBinObjGeneric obj1;
    DPSBinObjGeneric obj2;
    DPSBinObjGeneric obj3;
    DPSBinObjGeneric obj4;
    DPSBinObjGeneric obj5;
    DPSBinObjGeneric obj6;
    DPSBinObjGeneric obj7;
    DPSBinObjGeneric obj8;
    } _dpsQ;
  static _dpsQ _dpsF = {
    DPS_DEF_TOKENTYPE, 0, 9, 80,
    {DPS_LITERAL|DPS_STRING, 0, 0, 72},	/* param text */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 166},	/* stringwidth */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 117},	/* pop */
    {DPS_LITERAL|DPS_INT, 0, 0, 0},
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 119},	/* printobject */
    {DPS_LITERAL|DPS_INT, 0, 0, 0},
    {DPS_LITERAL|DPS_INT, 0, 0, 1},
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 119},	/* printobject */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 70},	/* flush */
    }; /* _dpsQ */
  register DPSBinObjRec *_dpsP = (DPSBinObjRec *)&_dpsF.obj0;
  register int _dps_offset = 72;
  static DPSResultsRec _dpsR[] = {
    { dps_tFloat, -1 },
    };
    _dpsR[0].value = (char *)width;


  _dpsP[0].length = strlen(text);
  _dpsP[0].val.stringVal = _dps_offset;
  _dps_offset += _dpsP[0].length;

  _dpsF.nBytes = _dps_offset+8;
  DPSSetResultTable(ctxt, _dpsR, 1);
  DPSBinObjSeqWrite(ctxt,(char *) &_dpsF,80);
  DPSWriteStringChars(ctxt, (char *)text, _dpsP[0].length);
  DPSAwaitReturnValues(ctxt);
}
#line 100 "stringutils.psw"

#line 273 "stringutils.c"
void PSWBBox(ctxt, text, llx, lly, urx, ury)
DPSContext ctxt; char *text; float *llx, *lly, *urx, *ury; 
{
  typedef struct {
    unsigned char tokenType;
    unsigned char sizeFlag;
    unsigned short topLevelCount;
    unsigned long nBytes;

    DPSBinObjReal obj0;
    DPSBinObjReal obj1;
    DPSBinObjGeneric obj2;
    DPSBinObjGeneric obj3;
    DPSBinObjGeneric obj4;
    DPSBinObjGeneric obj5;
    DPSBinObjGeneric obj6;
    DPSBinObjGeneric obj7;
    DPSBinObjGeneric obj8;
    DPSBinObjGeneric obj9;
    DPSBinObjGeneric obj10;
    DPSBinObjGeneric obj11;
    DPSBinObjGeneric obj12;
    DPSBinObjGeneric obj13;
    DPSBinObjGeneric obj14;
    DPSBinObjGeneric obj15;
    DPSBinObjGeneric obj16;
    DPSBinObjGeneric obj17;
    DPSBinObjGeneric obj18;
    DPSBinObjGeneric obj19;
    DPSBinObjGeneric obj20;
    DPSBinObjGeneric obj21;
    DPSBinObjGeneric obj22;
    DPSBinObjGeneric obj23;
    } _dpsQ;
  static _dpsQ _dpsF = {
    DPS_DEF_TOKENTYPE, 0, 24, 200,
    {DPS_LITERAL|DPS_REAL, 0, 0, 0.0},
    {DPS_LITERAL|DPS_REAL, 0, 0, 0.0},
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 107},	/* moveto */
    {DPS_LITERAL|DPS_STRING, 0, 0, 192},	/* param text */
    {DPS_LITERAL|DPS_BOOL, 0, 0, 0},
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 17},	/* charpath */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 68},	/* flattenpath */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 115},	/* pathbbox */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 117},	/* pop */
    {DPS_LITERAL|DPS_INT, 0, 0, 2},
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 119},	/* printobject */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 117},	/* pop */
    {DPS_LITERAL|DPS_INT, 0, 0, 0},
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 119},	/* printobject */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 117},	/* pop */
    {DPS_LITERAL|DPS_INT, 0, 0, 1},
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 119},	/* printobject */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 117},	/* pop */
    {DPS_LITERAL|DPS_INT, 0, 0, 3},
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 119},	/* printobject */
    {DPS_LITERAL|DPS_INT, 0, 0, 0},
    {DPS_LITERAL|DPS_INT, 0, 0, 4},
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 119},	/* printobject */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 70},	/* flush */
    }; /* _dpsQ */
  register DPSBinObjRec *_dpsP = (DPSBinObjRec *)&_dpsF.obj0;
  register int _dps_offset = 192;
  static DPSResultsRec _dpsR[] = {
    { dps_tFloat, -1 },
    { dps_tFloat, -1 },
    { dps_tFloat, -1 },
    { dps_tFloat, -1 },
    };
    _dpsR[0].value = (char *)llx;
    _dpsR[1].value = (char *)lly;
    _dpsR[2].value = (char *)urx;
    _dpsR[3].value = (char *)ury;


  _dpsP[3].length = strlen(text);
  _dpsP[3].val.stringVal = _dps_offset;
  _dps_offset += _dpsP[3].length;

  _dpsF.nBytes = _dps_offset+8;
  DPSSetResultTable(ctxt, _dpsR, 4);
  DPSBinObjSeqWrite(ctxt,(char *) &_dpsF,200);
  DPSWriteStringChars(ctxt, (char *)text, _dpsP[3].length);
  DPSAwaitReturnValues(ctxt);
}
#line 110 "stringutils.psw"




/*
 * The following piece of example code was sent to me by a person at
 * ps-file-person@adobe.com.
 */
/*======================= PSWgetwidths */
#line 369 "stringutils.c"
void PSWgetwidths(ctxt, widths)
DPSContext ctxt; float widths[]; 
{
  typedef struct {
    unsigned char tokenType;
    unsigned char topLevelCount;
    unsigned short nBytes;

    DPSBinObjGeneric obj0;
    DPSBinObjGeneric obj1;
    DPSBinObjGeneric obj2;
    DPSBinObjGeneric obj3;
    DPSBinObjGeneric obj4;
    DPSBinObjGeneric obj5;
    DPSBinObjGeneric obj6;
    DPSBinObjGeneric obj7;
    DPSBinObjGeneric obj8;
    DPSBinObjGeneric obj9;
    DPSBinObjGeneric obj10;
    DPSBinObjGeneric obj11;
    DPSBinObjGeneric obj12;
    DPSBinObjGeneric obj13;
    DPSBinObjGeneric obj14;
    DPSBinObjGeneric obj15;
    DPSBinObjGeneric obj16;
    DPSBinObjGeneric obj17;
    DPSBinObjGeneric obj18;
    DPSBinObjGeneric obj19;
    DPSBinObjGeneric obj20;
    char obj21[1];
    } _dpsQ;
  static _dpsQ _dpsF = {
    DPS_DEF_TOKENTYPE, 9, 173,
    {DPS_LITERAL|DPS_INT, 0, 0, 65},
    {DPS_LITERAL|DPS_INT, 0, 0, 1},
    {DPS_LITERAL|DPS_INT, 0, 0, 66},
    {DPS_EXEC|DPS_ARRAY, 0, 12, 72},
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 72},	/* for */
    {DPS_LITERAL|DPS_INT, 0, 0, 0},
    {DPS_LITERAL|DPS_INT, 0, 0, 1},
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 119},	/* printobject */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 70},	/* flush */
    {DPS_LITERAL|DPS_STRING, 0, 1, 168},
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 56},	/* dup */
    {DPS_LITERAL|DPS_INT, 0, 0, 0},
    {DPS_LITERAL|DPS_INT, 0, 0, 4},
    {DPS_LITERAL|DPS_INT, 0, 0, -1},
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 135},	/* roll */
    {DPS_EXEC|DPS_NAME, 0, 0, 0},	/* pstack */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 120},	/* put */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 166},	/* stringwidth */
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 117},	/* pop */
    {DPS_LITERAL|DPS_INT, 0, 0, 0},
    {DPS_EXEC|DPS_NAME, 0, DPSSYSNAME, 119},	/* printobject */
    {'X'},
    }; /* _dpsQ */
  register DPSBinObjRec *_dpsP = (DPSBinObjRec *)&_dpsF.obj0;
  static DPSResultsRec _dpsR[] = {
    { dps_tFloat },
    };
    _dpsR[0].count = 256;
    _dpsR[0].value = (char *)widths;

  {
  static int _dpsT = 1;

  if (_dpsT) {
    static char *_dps_names[] = {
	"pstack"};
    long int *_dps_nameVals[1];
    _dps_nameVals[0] = (long int *)&_dpsP[15].val.nameVal;

    DPSMapNames(ctxt, 1, _dps_names, _dps_nameVals);
    _dpsT = 0;
    }
  }


  DPSSetResultTable(ctxt, _dpsR, 1);
  DPSBinObjSeqWrite(ctxt,(char *) &_dpsF,173);
  DPSAwaitReturnValues(ctxt);
}
#line 124 "stringutils.psw"

