/*
 * file:     main.c
 * author:   Wes Barris
 * date:     4/22/92
 * purpose:  X/GL-based image designer
 *
 * copyright info:
 *
 *    @Copyright, Research Equipment Inc., d/b/a Minnesota Supercomputer
 *    Center, Inc., 1992
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include "proto.h"
#include <gl/gl.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/MwmUtil.h>
#include <X11/Xmu/Editres.h>
#include "Umsc/List.h"

static String fallbackResources[] = {
#include "fallback.h"
    NULL,
};

extern int	_EditResCheckMessages();
extern int	nFrames;
extern int	currentFrame;

DESI		desi;
UmscList	theList;
char		systype[10];

int
compareObj(obj1, obj2)
GenericInfo	*obj1, *obj2;
{
   int	result = 0;

   if ((obj1 != NULL) && (obj2 != NULL)) {
      if (obj1->w == obj2->w)
          result = 1;
       }
   return (result);

}


void
freeObj(GenericInfo *thisObject)
{
   if (thisObject != NULL) {
      if (thisObject->objtype == TXTOBJ)
         free(thisObject->u.text.text);
      else if (thisObject->objtype == IMGOBJ) {
         free(thisObject->u.image.filename);
         free(thisObject->u.image.imgbuf);
         }
      else if (thisObject->objtype == MAPOBJ) {
         free(thisObject->u.cmap.filename);
         free(thisObject->u.cmap.imgbuf);
         }
      free(thisObject);
      }
   else
      fprintf(stderr, "Tried to free NULL object\n");
}

void
SetDesiTitle(char *filename)
{
   Arg		args[3];
   char		str[80], *sP, *bP, *eP;
   int		n;
/*
 * Set the initial Desi title.
 */
   if (filename == NULL)
      sprintf(str, "Desi %1d.%1d.%1d (untitled)",
                    MAJOR_VERSION, MINOR_VERSION, PETTY_VERSION);
/*
 * Change only the frame number.  Read the existing title to get the
 * old filename.
 */
   else {
      if (!strcmp(filename, "----")) {
         n = 0;
         XtSetArg(args[n], XmNtitle, &sP); n++;
         XtGetValues(desi.toplevel, args, n);
         bP = strchr(sP, ' ');		/* points at _1.2 */
         bP = strchr(++bP, ' ');	/* points at _filename.dzi */
         /*eP = strchr(++bP, ' ');*/	/* points at space after filename */
         if ((eP = strchr(++bP, ' ')) != NULL)
            strcpy(eP, "\0");
         if (nFrames == 1)
            sprintf(str, "Desi %1d.%1d.%1d %s",
                          MAJOR_VERSION, MINOR_VERSION, PETTY_VERSION, bP);
         else
            sprintf(str, "Desi %1d.%1d.%1d %s Frame %d of %d",
                          MAJOR_VERSION, MINOR_VERSION, PETTY_VERSION, bP,
                          currentFrame, nFrames);
         /*free(sP);*/
         }
/*
 * We have a new filename -- redo the title.
 */
      else {
         if (nFrames == 1)
            sprintf(str, "Desi %1d.%1d.%1d %s",
                          MAJOR_VERSION, MINOR_VERSION, PETTY_VERSION, filename);
         else
            sprintf(str, "Desi %1d.%1d.%1d %s Frame %d of %d",
                          MAJOR_VERSION, MINOR_VERSION, PETTY_VERSION, filename, currentFrame,
                          nFrames);
         }
      }
   n = 0;
   XtSetArg(args[n], XmNtitle, str); n++;
   XtSetValues(desi.toplevel, args, n);
   return;
}


void
unmanage(callingWidget, targetWidget)
Widget	callingWidget,
	targetWidget;
{
   XtUnmanageChild(targetWidget);
}


main(argc, argv)
unsigned int	argc;
char	*argv[];
{
   Widget	form,
		menubar;
   int		n;
   Arg		args[10];

   if (getgdesc(GD_BITS_NORM_SNG_RED) == 0) {
      printf("Sorry, this program requires single buffered RGB mode.\n");
      exit(1);
      }
   UmscListInit(&theList, *compareObj, *freeObj);

   n = 0;
   desi.toplevel = XtAppInitialize(&(desi.appContext), APP_CLASS, NULL,
      NULL, &argc, argv, fallbackResources, args, n);
   XtAddEventHandler(desi.toplevel, (EventMask)0, True,
                     (XtEventHandler)_EditResCheckMessages, NULL);
/*
 * I want to see when the toplevel shell is resized.
 */
   /*XtAddEventHandler(desi.toplevel, ResizeRedirectMask, True,
                     topLevelResizeCB, NULL);*/
   gversion(systype);
/*
 * Desi is held together by a form.
 */
   n = 0;
   form = XmCreateForm(desi.toplevel, "form", args, n);
   XtManageChild(form);
/*
 * Create Desi's main children.
 */
   menubar		=	MenuBarInit(form);
   desi.container	=	BBoardInit(form, menubar);
   desi.back.w		=	BackInit(desi.container);
/*
 * Anything that needs to be initialized...
 */
   InitFont();
   InitIcon();
   SetDesiTitle(NULL);
   XtRealizeWidget(desi.toplevel);
/*
 * Read in a data file if any.
 */
   /*if (argc == 2)
      OpenDesi(argv[1]);*/
/*
 * Let's go!
 */
   XtAppMainLoop(desi.appContext);
   exit(0);
}
