/*
 * file:     colorMenu.c
 * author:   Wes Barris
 * date:     9/02/92
 * purpose:  creates text Color menu
 *
 * copyright info:
 *
 *    @Copyright 1992
 *    Research Equipment Inc. dba Minnesota Supercomputer Center
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "desi.h"
#include "proto.h"
#include <gl/gl.h>
#include <X11/StringDefs.h>
#include <X11/Xirisw/GlxMDraw.h>
#include <Xm/CascadeB.h>
#include <Xm/Form.h>
#include <Xm/Frame.h>
#include <Xm/Label.h>
#include <Xm/RowColumn.h>
#include <Xm/PushB.h>
#include <Xm/Scale.h>
#include <Xm/Separator.h>
#include <Xm/ToggleB.h>
#include "Umsc/List.h"

extern DESI		desi;
extern UmscList		theList;
extern GenericInfo	defaultInfo;

static GLXconfig glxConfig [] = {
    { GLX_NORMAL, GLX_RGB, TRUE },
    { 0, 0, 0 }
};

static Widget		textRGBPanel = NULL,
			glxrgb,
			useShape,
			red, grn, blu;
static short		tcolor[3];
static short		orig_color[3];
static int		t_or_s;

static void
SetColorCB(Widget w, XtPointer client_data, char *call_data)
{
   GenericInfo	*thisObject;
   int		n;
/*
 * This is kinda sneaky -- I am passing the array subscript for the color
 * value in client_data.  This allows me to avoid and expensive string
 * comparison.
 */
   if (t_or_s == 1)	/* this would mean text color */
      tcolor[(int)client_data] = ((XmScaleCallbackStruct *)call_data)->value;
/*
 * Are there any selected text objects?
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (n=0; n<UmscListGetCount(theList); n++) {
      if (thisObject->objtype == TXTOBJ &&
          thisObject->selected == True &&
          t_or_s == 1) {
         thisObject->u.text.cv[0] = tcolor[0];
         thisObject->u.text.cv[1] = tcolor[1];
         thisObject->u.text.cv[2] = tcolor[2];
         DrawText(thisObject);
         defaultInfo.u.text.cv[0] = tcolor[0]; /* and now use */
         defaultInfo.u.text.cv[1] = tcolor[1]; /* this as the*/
         defaultInfo.u.text.cv[2] = tcolor[2]; /* default color */
         }
      else if (thisObject->selected == True &&
               thisObject->decoration &&
               t_or_s == 2) {
         thisObject->dec[0] = tcolor[0];
         thisObject->dec[1] = tcolor[1];
         thisObject->dec[2] = tcolor[2];
         DrawObject(thisObject);
         defaultInfo.dec[0] = tcolor[0]; /* and now use */
         defaultInfo.dec[1] = tcolor[1]; /* this as the*/
         defaultInfo.dec[2] = tcolor[2]; /* default color */
         }
      thisObject = UmscListGetNext(theList);
      }
}


static void
ClearGLXCB(Widget w, XtPointer client_data, char *call_data)
{
   GLXwinset(XtDisplay(desi.toplevel), XtWindow(glxrgb));
   c3s(tcolor);
   clear();
}


static void
SetGLXColorCB(Widget w, XtPointer client_data, char *call_data)
{
/*
 * This is kinda sneaky -- I am passing the array subscript for the color
 * value in client_data.  This allows me to avoid and expensive string
 * comparison.
 */
   tcolor[(int)client_data] = ((XmScaleCallbackStruct *)call_data)->value;
   ClearGLXCB(w, client_data, call_data);
}


static void
CancelCB(Widget w, XtPointer client_data, char *call_data)
{
   GenericInfo	*thisObject;
   int		n;

   if (t_or_s == 1) {
      tcolor[0] = defaultInfo.u.text.cv[0] = orig_color[0];
      tcolor[1] = defaultInfo.u.text.cv[1] = orig_color[1];
      tcolor[2] = defaultInfo.u.text.cv[2] = orig_color[2];
      }
   else {
      tcolor[0] = defaultInfo.dec[0] = orig_color[0];
      tcolor[1] = defaultInfo.dec[1] = orig_color[1];
      tcolor[2] = defaultInfo.dec[2] = orig_color[2];
      }
   ClearGLXCB(w, client_data, call_data);
/*
 * Are there any selected text objects?
 */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (n=0; n<UmscListGetCount(theList); n++) {
      if (thisObject->objtype == TXTOBJ &&
          thisObject->selected == True &&
          t_or_s == 1) {
         thisObject->u.text.cv[0] = defaultInfo.u.text.cv[0];
         thisObject->u.text.cv[1] = defaultInfo.u.text.cv[1];
         thisObject->u.text.cv[2] = defaultInfo.u.text.cv[2];
         DrawText(thisObject);
         }
      else if (thisObject->selected == True &&
               thisObject->decoration &&
               t_or_s == 2) {
         thisObject->dec[0] = defaultInfo.dec[0];
         thisObject->dec[1] = defaultInfo.dec[1];
         thisObject->dec[2] = defaultInfo.dec[2];
         DrawText(thisObject);
         }
      thisObject = UmscListGetNext(theList);
      }
   if (t_or_s == 1) {
      XmScaleSetValue(red, defaultInfo.u.text.cv[0]);
      XmScaleSetValue(grn, defaultInfo.u.text.cv[1]);
      XmScaleSetValue(blu, defaultInfo.u.text.cv[2]);
      }
   else {
      XmScaleSetValue(red, defaultInfo.dec[0]);
      XmScaleSetValue(grn, defaultInfo.dec[1]);
      XmScaleSetValue(blu, defaultInfo.dec[2]);
      }
}


static void
CheckShapeCB(w, client_data, call_data)
Widget				w;
int				client_data;
XmPushButtonCallbackStruct	*call_data;
{
   GenericInfo	*thisObject;
   int		n;

   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (n=0; n<UmscListGetCount(theList); n++) {
      if (thisObject->objtype == TXTOBJ && thisObject->selected == True) {
         thisObject->u.text.useShape =
                                (XmToggleButtonGetState(useShape)? 1 : 0 );
         if (thisObject->u.text.useShape && thisObject->decoration == BORDER)
            thisObject->decoration = 0;
         SetShapeMask(thisObject);
         }
      thisObject = UmscListGetNext(theList);
      }
}


static Widget
InitColorPanel(void)
{
   Arg		args[10];
   Widget	rcrgb,
		rcbut,
		frameglx,
		sep2,
		doneButton,
		cancelButton;
   int		n;
/*
 * Display a control panel used for tweeking the colors.
 * NOTE:  We're going to create the RGB sliders using the default text info.
 * This will not necessarily match the selected text.
 */
   n = 0;
   textRGBPanel = XmCreateFormDialog(desi.toplevel, "textRGBPanel", args, n);

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
   rcrgb = XtCreateManagedWidget("rcrgb", xmRowColumnWidgetClass,
                                 textRGBPanel, args, n);

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, rcrgb); n++;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
   sep2 = XtCreateManagedWidget("separator", xmSeparatorWidgetClass,
                                textRGBPanel, args, n);

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNleftWidget, rcrgb); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNbottomAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNbottomWidget, sep2); n++;
   frameglx = XtCreateManagedWidget("frameglx", xmFrameWidgetClass,
                                    textRGBPanel, args, n);

   n = 0;
   XtSetArg(args[n], GlxNglxConfig, glxConfig); n++;
   glxrgb = XtCreateManagedWidget("glxrgb", glxMDrawWidgetClass,
                                  frameglx, args, n);
   XtAddCallback(glxrgb, GlxNginitCallback, (XtCallbackProc)GLInitCB, (XtPointer)0);
   XtAddCallback(glxrgb, GlxNresizeCallback, (XtCallbackProc)GLInitCB, (XtPointer)0);
   XtAddCallback(glxrgb, GlxNexposeCallback, (XtCallbackProc)ClearGLXCB, (XtPointer)0);

   n = 0;
   XtSetArg(args[n], XmNtopAttachment, XmATTACH_WIDGET); n++;
   XtSetArg(args[n], XmNtopWidget, sep2); n++;
   XtSetArg(args[n], XmNleftAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNrightAttachment, XmATTACH_FORM); n++;
   XtSetArg(args[n], XmNbottomAttachment, XmATTACH_FORM); n++;
   /*XtSetArg(args[n], XmNorientation, XmHORIZONTAL); n++;*/
   XtSetArg(args[n], XmNorientation, XmVERTICAL); n++;
   rcbut = XtCreateManagedWidget("rcbut", xmRowColumnWidgetClass,
                                 textRGBPanel, args, n);

   n = 0;
   red = XtCreateManagedWidget("red", xmScaleWidgetClass, rcrgb, args, n);
   n = 0;
   grn = XtCreateManagedWidget("grn", xmScaleWidgetClass, rcrgb, args, n);
   n = 0;
   blu = XtCreateManagedWidget("blu", xmScaleWidgetClass, rcrgb, args, n);

   n = 0;
   useShape = XtCreateManagedWidget("useShape", xmToggleButtonWidgetClass,
                                      rcbut, args, n);
   n = 0;
   doneButton = XtCreateManagedWidget("doneButton", xmPushButtonWidgetClass,
                                      rcbut, args, n);
   n = 0;
   cancelButton = XtCreateManagedWidget("cancelButton", xmPushButtonWidgetClass,
                                        rcbut, args, n);
   XtAddCallback(doneButton, XmNactivateCallback, (XtCallbackProc)CheckShapeCB, NULL);
   XtAddCallback(doneButton, XmNactivateCallback, (XtCallbackProc)unmanageCB, (XtPointer)textRGBPanel);
   XtAddCallback(cancelButton, XmNactivateCallback, (XtCallbackProc)CancelCB, (XtPointer)textRGBPanel);
/*
 * Have all the selected text objects updated to this color.
 */
   XtAddCallback(red, XmNvalueChangedCallback, (XtCallbackProc)SetColorCB, (XtPointer)0);
   XtAddCallback(red, XmNvalueChangedCallback, (XtCallbackProc)SetGLXColorCB, (XtPointer)0);
   XtAddCallback(red, XmNdragCallback,         (XtCallbackProc)SetGLXColorCB, (XtPointer)0);
   XtAddCallback(grn, XmNvalueChangedCallback, (XtCallbackProc)SetColorCB, (XtPointer)1);
   XtAddCallback(grn, XmNvalueChangedCallback, (XtCallbackProc)SetGLXColorCB, (XtPointer)1);
   XtAddCallback(grn, XmNdragCallback,         (XtCallbackProc)SetGLXColorCB, (XtPointer)1);
   XtAddCallback(blu, XmNvalueChangedCallback, (XtCallbackProc)SetColorCB, (XtPointer)2);
   XtAddCallback(blu, XmNvalueChangedCallback, (XtCallbackProc)SetGLXColorCB, (XtPointer)2);
   XtAddCallback(blu, XmNdragCallback,         (XtCallbackProc)SetGLXColorCB, (XtPointer)2);

   return textRGBPanel;
}


void
ColorPanelCB(Widget w, XtPointer client_data, char *call_data)
{
   GenericInfo	*thisObject;
   int		n;

   if (textRGBPanel == NULL)
      textRGBPanel = InitColorPanel();
/*
 * If called from the text menu, client_data will be the string "color".
 * If called from the dropshadow menu, client_data will be 2.
 */
   if ((int)client_data == 2)
      t_or_s = (int)client_data;
   else
      t_or_s = 1;
/*
 * Are there any selected objects?
 */
   XmToggleButtonSetState(useShape, False, False); /* first assume false */
   thisObject = UmscListSetCurrent(theList, UmscFIRST);
   for (n=0; n<UmscListGetCount(theList); n++) {
      if (thisObject->objtype == TXTOBJ &&
          thisObject->selected == True &&
          t_or_s == 1) {
/*
 * If there is a selected text object and we are setting the text color...
 */
         tcolor[0] = orig_color[0] = thisObject->u.text.cv[0];
         tcolor[1] = orig_color[1] = thisObject->u.text.cv[1];
         tcolor[2] = orig_color[2] = thisObject->u.text.cv[2];
         XmScaleSetValue(red, tcolor[0]);
         XmScaleSetValue(grn, tcolor[1]);
         XmScaleSetValue(blu, tcolor[2]);
         if (thisObject->u.text.useShape)
            XmToggleButtonSetState(useShape, True, False);
         XtManageChild(textRGBPanel);
         return;
         }
      else if (thisObject->selected &&
               thisObject->decoration &&
               t_or_s == 2) {
/*
 * If there is any selected object with a drop shadow and we are
 * editing the shadow color...
 */
         tcolor[0] = orig_color[0] = thisObject->dec[0];
         tcolor[1] = orig_color[1] = thisObject->dec[1];
         tcolor[2] = orig_color[2] = thisObject->dec[2];
         XmScaleSetValue(red, tcolor[0]);
         XmScaleSetValue(grn, tcolor[1]);
         XmScaleSetValue(blu, tcolor[2]);
         XtManageChild(textRGBPanel);
         return;
         }
      thisObject = UmscListGetNext(theList);
      }
/*
 * Save the current colors.
 */
   XtManageChild(textRGBPanel);
}
