/*
 * file:     PSutils.h
 * author:   Wes Barris
 * date:     2/25/93
 * purpose:  Header file for display postscript routines.
 *
 * copyright info:
 *
 *    @Copyright, Research Equipment Inc., d/b/a Minnesota Supercomputer
 *    Center, Inc., 1992
 *
 */
#define JUSTIFY_LEFT	1
#define JUSTIFY_CENTER	2
#define JUSTIFY_RIGHT	3

#define COURIER		1
#define HELVETICA	2
#define SYMBOL		3
#define TIMES		4
#define UTOPIA		5

#define AMIE		6
#define CAVE		7
#define CURL		8
#define DJB		9
#define HAEBERLI	10
#define HONESTY		11
#define INJA		12
#define LAURA		13
#define MESSENGER	14
#define ROCK		15
#define SORORITY	16
#define STROKEB		17
#define STROKER		18
#define ELFIN		19

#define N_EXT_FONTS	31
/*
 * Font metrics.
 */
static struct {
   char		*name;		/* name of the font */
   int		id;		/* font id */
   float	himult;		/* hi multiplier */
   float	lomult;		/* lo multiplier */
   float	xmult;		/* x offset multiplier multiplier */
   } font_info[] = {
   { "Amie",		AMIE,		0.812,	0.462,	-0.060	},
   { "Cave",		CAVE,		0.700,	0.361,	-0.060	},
   { "Courier",		COURIER,	0.657,	0.157,	0.005	},
   { "Courier-Bold",	COURIER,	0.658,	0.146,	0.022	},
   { "Courier-BoldOblique",COURIER,	0.658,	0.146,	0.022	},
   { "Courier-Oblique",	COURIER,	0.657,	0.157,	0.005	},
   { "Curl-Roman",	CURL,		0.741,	0.367,	0.256	},
   { "DJB",		DJB,		0.861,	0.532,	0.603	},
   { "Haeberli",	HAEBERLI,	0.653,	0.396,	0.129	},
   { "Helvetica",	HELVETICA,	0.728,	0.220,	0.016	},
   { "Helvetica-Bold",	HELVETICA,	0.727,	0.217,	-0.023	},
   { "Helvetica-BoldOblique",HELVETICA,	0.727,	0.217,	0.042	},
   { "Helvetica-Oblique",HELVETICA,	0.728,	0.220,	0.060	},
   { "Honesty",		HONESTY,	0.759,	0.378,	0.179	},
   { "Inja",		INJA,		0.765,	0.372,	0.364	},
   { "Laura",		LAURA,		0.656,	0.253,	-0.060	},
   { "Messenger",	MESSENGER,	0.609,	0.268,	0.001	},
   { "Rock",		ROCK,		0.683,	0.320,	-0.060	},
   { "Sorority",	SORORITY,	0.738,	0.382,	-0.060	},
   { "Stroke-Bold",	STROKEB,	0.702,	0.331,	0.137	},
   { "Stroke-Roman",	STROKER,	0.705,	0.331,	0.184	},
   { "Symbol",		SYMBOL,		0.764,	0.231,	0.009	},
   { "Times-Bold",	TIMES,		0.676,	0.206,	0.057	},
   { "Times-BoldItalic",TIMES,		0.699,	0.205,	0.189	},
   { "Times-Italic",	TIMES,		0.683,	0.207,	0.147	},
   { "Times-Roman",	TIMES,		0.700,	0.218,	0.070	},
   { "Tymes-Elfin",	ELFIN,		0.790,	0.365,	0.080	},
   { "Utopia-Bold",	UTOPIA,		0.742,	0.242,	0.012	},
   { "Utopia-BoldItalic",UTOPIA,	0.742,	0.242,	0.094	},
   { "Utopia-Italic",	UTOPIA,		0.742,	0.242,	0.072	},
   { "Utopia-Regular",	UTOPIA,		0.742,	0.242,	0.033	},
   };
/*
 * NOTES:
 *
 * Changed Times-Roman Hi from .683 to .700
 */
