/*
 *	fzoom- 
 *		Magnify or minify an array of longs using impulse zoom
 *		with no filtering.
 *
 * 		    		Paul Haeberli - 1992
 *
 */
#include "math.h"
#include "stdio.h"

#define GRIDTOFLOAT(pos,n)	(((pos)+0.5)/(n))
#define FLOATTOGRID(pos,n)	((pos)*(n))

static int zanx, zbnx;
static unsigned long **zmap;
static int zptrs;

static void makemap(int anx, int bnx)
{
    int n, x, y;
    unsigned long **zmapptr;
    unsigned long *ybase;
    float fx, fy;
    int ax, ay;

    if(bnx>zptrs) {
	if(zmap)
	    free(zmap);
	zmap = (unsigned long **)malloc(bnx*sizeof(unsigned long *));
  	zptrs = bnx;
    }
    zmapptr = zmap;
    for(x=0; x<bnx; x++) {
	fx = GRIDTOFLOAT(x,bnx);
	ax = FLOATTOGRID(fx,anx);
	*zmapptr++ = (unsigned long *)(ax<<2);
    }
    zanx = anx;
    zbnx = bnx;
}

/*
 *	general zoom follows
 *
 */
void
fastzoom(unsigned long* abuf, unsigned long* bbuf, 
				int anx, int any, int bnx, int bny)
{
    unsigned long **zmapptr;
    unsigned long *dptr;
    int x, y, base, ay;
    float fy;

    if(zanx != anx || zbnx != bnx) 
	makemap(anx,bnx);
    dptr = bbuf;
    y = bny;
    for(y=0; y<bny; y++) {
    	x = bnx;
	zmapptr = zmap;
	fy = GRIDTOFLOAT(y,bny);
	ay = FLOATTOGRID(fy,any);
	base = (int)(abuf+(ay*anx));
        while(x>=8) {
	    dptr[0] = *(long*)(base+(unsigned int)(zmapptr[0]));
	    dptr[1] = *(long*)(base+(unsigned int)(zmapptr[1]));
	    dptr[2] = *(long*)(base+(unsigned int)(zmapptr[2]));
	    dptr[3] = *(long*)(base+(unsigned int)(zmapptr[3]));
	    dptr[4] = *(long*)(base+(unsigned int)(zmapptr[4]));
	    dptr[5] = *(long*)(base+(unsigned int)(zmapptr[5]));
	    dptr[6] = *(long*)(base+(unsigned int)(zmapptr[6]));
	    dptr[7] = *(long*)(base+(unsigned int)(zmapptr[7]));
	    dptr += 8;
	    zmapptr += 8;
	    x -= 8;
	}
	while(x--) 
	    *dptr++ = *(long*)(base+(unsigned int)(*zmapptr++));
    }
}

#ifdef TESTIT
float gettime();

main(argc,argv)
int argc;
char **argv;
{
    int anx, any;
    int bnx, bny;
    unsigned long *abuf, *bbuf;
    float sc;
    int i;

    sc = atof(argv[1]);
    sizeofimage("in.rgb",&anx,&any);
    abuf = (unsigned long *)longimagedata("in.rgb");
    bnx = sc*anx;
    bny = sc*any;
    bbuf = (unsigned long *)malloc(bnx*bny*sizeof(long));
    fastzoom(abuf,bbuf,anx,any,bnx,bny);

    sleep(1);
    cleartime();
    for(i=0; i<50; i++) 
        fastzoom(abuf,bbuf,anx,any,bnx,bny);
    printf("time is %f\n",gettime());

    longstoimage(bbuf,bnx,bny,3,"out.rgb");
    system("istat out.rgb");
    system("ipaste out.rgb");
}
#endif
