
/*
    GLE Extrusion, Sweep and Tubing Library Version 2.1
    Copyright (C) 1991, 1993, 1995 Linas Vepstas (linas@fc.net)

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Contact linas by writing to linas@fc.net or
    Linas Vepstas
    1518 Enfield Road
    Austin TX 78703-3424
*/

#include "port.h"

/* 
 * MODULE NAME: rotate.c
 *
 * FUNCTION:
 * This module contains three different routines that compute rotation
 * matricies and load them into GL.
 * Detailed description is provided below.
 *
 * DEPENDENCIES:
 * The routines call GL matrix routines.
 *
 * HISTORY:
 * Developed & written, Linas Vepstas, Septmeber 1991
 * Double precision port, March 1993
 *
 * DETAILED DESCRIPTION:
 * This module contains three routines:
 * --------------------------------------------------------------------
 *
 * void urot_about_axis (float m[4][4],      --- returned
 *                       float angle,        --- input 
 *                       float axis[3])      --- input
 * Computes a rotation matrix.
 * The rotation is around the the direction specified by the argument
 * argument axis[3].  User may specify vector which is not of unit
 * length.  The angle of rotation is specified in degrees, and is in the
 * right-handed direction.
 *
 * void rot_about_axis (float angle,        --- input 
 *                      float axis[3])      --- input
 * Same as above routine, except that the matrix is multiplied into the
 * GL matrix stack.
 *
 * --------------------------------------------------------------------
 *
 * void urot_axis (float m[4][4],      --- returned
 *                 float omega,        --- input
 *                 float axis[3])      --- input
 * Same as urot_about_axis(), but angle specified in radians.
 * It is assumed that the argument axis[3] is a vector of unit length.
 * If it is not of unit length, the returned matrix will not be correct.
 *
 * void rot_axis (float omega,        --- input
 *                float axis[3])      --- input
 * Same as above routine, except that the matrix is multiplied into the
 * GL matrix stack.
 *
 * --------------------------------------------------------------------
 *
 * void urot_omega (float m[4][4],       --- returned
 *                  float omega[3])      --- input
 * same as urot_axis(), but the angle is taken as the length of the
 * vector omega[3]
 *
 * void rot_omega (float omega[3])      --- input
 * Same as above routine, except that the matrix is multiplied into the
 * GL matrix stack.
 *
 * --------------------------------------------------------------------
 */

   
/* ========================================================== */

#ifdef __GUTIL_DOUBLE
void rot_axis (double omega, 		/* input */
               double axis[3])		/* input */
{
   double m[4][4];

   (void) urot_axis_d (m, omega, axis);
   MULTMATRIX_D (m);

}
#else 

void rot_axis (float omega, 		/* input */
               float axis[3])		/* input */
{
   float m[4][4];

   (void) urot_axis_f (m, omega, axis);
   MULTMATRIX_F (m);

}
#endif 

/* ========================================================== */

#ifdef __GUTIL_DOUBLE
void rot_about_axis_d (double angle, 		/* input */
                       double axis[3])		/* input */
{
   double m[4][4];

   (void) urot_about_axis_d (m, angle, axis);
   MULTMATRIX_D (m);
}

#else
void rot_about_axis_f (float angle, 		/* input */
                       float axis[3])		/* input */
{
   float m[4][4];

   (void) urot_about_axis_f (m, angle, axis);
   MULTMATRIX_F (m);
}
#endif

/* ========================================================== */

#ifdef __GUTIL_DOUBLE
void rot_omega (double axis[3])		/* input */
{
   double m[4][4];

   (void) urot_omega_d (m, axis);
   MULTMATRIX_D(m);
}
#else
void rot_omega (float axis[3])		/* input */
{
   float m[4][4];

   (void) urot_omega_f (m, axis);
   MULTMATRIX_F(m);
}
#endif

/* ========================================================== */
